/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
const NG_DEV_MODE = typeof ngDevMode === 'undefined' || !!ngDevMode;
function createListOfWarnings(warnings) {
    const LINE_START = '\n - ';
    return `${LINE_START}${warnings.filter(Boolean).map(warning => warning).join(LINE_START)}`;
}
export function warnValidation(warnings) {
    NG_DEV_MODE && console.warn(`animation validation warnings:${createListOfWarnings(warnings)}`);
}
export function warnTriggerBuild(name, warnings) {
    NG_DEV_MODE &&
        console.warn(`The animation trigger "${name}" has built with the following warnings:${createListOfWarnings(warnings)}`);
}
export function warnRegister(warnings) {
    NG_DEV_MODE &&
        console.warn(`Animation built with the following warnings:${createListOfWarnings(warnings)}`);
}
export function triggerParsingWarnings(name, warnings) {
    NG_DEV_MODE &&
        console.warn(`Animation parsing for the ${name} trigger presents the following warnings:${createListOfWarnings(warnings)}`);
}
export function pushUnrecognizedPropertiesWarning(warnings, props) {
    if (props.length) {
        warnings.push(`The following provided properties are not recognized: ${props.join(', ')}`);
    }
}
export function pushNonAnimatablePropertiesWarning(warnings, props) {
    if (props.length) {
        warnings.push(`The following provided properties are not animatable: ${props.join(', ')}\n   (see: https://developer.mozilla.org/en-US/docs/Web/CSS/CSS_animated_properties)`);
    }
}
//# sourceMappingURL=data:application/json;base64,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