/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
import { ListKeyManager } from './list-key-manager';
export class ActiveDescendantKeyManager extends ListKeyManager {
    setActiveItem(index) {
        if (this.activeItem) {
            this.activeItem.setInactiveStyles();
        }
        super.setActiveItem(index);
        if (this.activeItem) {
            this.activeItem.setActiveStyles();
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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