"use strict";
/**
 * @license
 * Copyright Google LLC All Rights Reserved.
 *
 * Use of this source code is governed by an MIT-style license that can be
 * found in the LICENSE file at https://angular.io/license
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProjectFromWorkspace = void 0;
const schematics_1 = require("@angular-devkit/schematics");
/**
 * Finds the specified project configuration in the workspace. Throws an error if the project
 * couldn't be found.
 */
function getProjectFromWorkspace(workspace, projectName) {
    if (!projectName) {
        // TODO(crisbeto): some schematics APIs have the project name as optional so for now it's
        // simpler to allow undefined and checking it at runtime. Eventually we should clean this up.
        throw new schematics_1.SchematicsException('Project name is required.');
    }
    const project = workspace.projects.get(projectName);
    if (!project) {
        throw new schematics_1.SchematicsException(`Could not find project in workspace: ${projectName}`);
    }
    return project;
}
exports.getProjectFromWorkspace = getProjectFromWorkspace;
//# sourceMappingURL=data:application/json;base64,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