import { Component, HostBinding, Input } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "@angular/router";
import * as i3 from "../../shared/html-attr.directive";
export class BreadcrumbItemComponent {
    get ariaCurrent() {
        return this.active ? 'page' : null;
    }
    get hostClasses() {
        return {
            'breadcrumb-item': true,
            active: this.active
        };
    }
}
BreadcrumbItemComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: BreadcrumbItemComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
BreadcrumbItemComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: BreadcrumbItemComponent, selector: "c-breadcrumb-item", inputs: { active: "active", url: "url", attributes: "attributes", linkProps: "linkProps" }, host: { properties: { "attr.aria-current": "this.ariaCurrent", "class": "this.hostClasses" } }, ngImport: i0, template: "<a *ngIf=\"!active; else activeItem\"\r\n   [routerLink]=\"url\"\r\n   [cHtmlAttr]=\"attributes ?? {}\"\r\n   [target]=\"attributes?.['target']\"\r\n   [queryParams]=\"linkProps?.queryParams ?? null\"\r\n   [fragment]=\"linkProps?.fragment\"\r\n   [queryParamsHandling]=\"linkProps?.queryParamsHandling ?? null\"\r\n   [preserveFragment]=\"linkProps?.preserveFragment ?? false\"\r\n   [skipLocationChange]=\"linkProps?.skipLocationChange ?? false\"\r\n   [replaceUrl]=\"linkProps?.replaceUrl ?? false\"\r\n   [state]=\"linkProps?.state ?? {}\"\r\n>\r\n  <ng-container *ngTemplateOutlet=\"defaultBreadcrumbItemContentTemplate\"></ng-container>\r\n</a>\r\n\r\n<ng-template #activeItem>\r\n  <span [cHtmlAttr]=\"attributes ?? {}\">\r\n      <ng-container *ngTemplateOutlet=\"defaultBreadcrumbItemContentTemplate\"></ng-container>\r\n  </span>\r\n</ng-template>\r\n\r\n<ng-template #defaultBreadcrumbItemContentTemplate>\r\n  <ng-content></ng-content>\r\n</ng-template>\r\n", styles: [":host{display:list-item;text-align:-webkit-match-parent;text-align:match-parent}\n"], dependencies: [{ kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i1.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: i2.RouterLinkWithHref, selector: "a[routerLink],area[routerLink]", inputs: ["target", "queryParams", "fragment", "queryParamsHandling", "preserveFragment", "skipLocationChange", "replaceUrl", "state", "relativeTo", "routerLink"] }, { kind: "directive", type: i3.HtmlAttributesDirective, selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: BreadcrumbItemComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-breadcrumb-item', template: "<a *ngIf=\"!active; else activeItem\"\r\n   [routerLink]=\"url\"\r\n   [cHtmlAttr]=\"attributes ?? {}\"\r\n   [target]=\"attributes?.['target']\"\r\n   [queryParams]=\"linkProps?.queryParams ?? null\"\r\n   [fragment]=\"linkProps?.fragment\"\r\n   [queryParamsHandling]=\"linkProps?.queryParamsHandling ?? null\"\r\n   [preserveFragment]=\"linkProps?.preserveFragment ?? false\"\r\n   [skipLocationChange]=\"linkProps?.skipLocationChange ?? false\"\r\n   [replaceUrl]=\"linkProps?.replaceUrl ?? false\"\r\n   [state]=\"linkProps?.state ?? {}\"\r\n>\r\n  <ng-container *ngTemplateOutlet=\"defaultBreadcrumbItemContentTemplate\"></ng-container>\r\n</a>\r\n\r\n<ng-template #activeItem>\r\n  <span [cHtmlAttr]=\"attributes ?? {}\">\r\n      <ng-container *ngTemplateOutlet=\"defaultBreadcrumbItemContentTemplate\"></ng-container>\r\n  </span>\r\n</ng-template>\r\n\r\n<ng-template #defaultBreadcrumbItemContentTemplate>\r\n  <ng-content></ng-content>\r\n</ng-template>\r\n", styles: [":host{display:list-item;text-align:-webkit-match-parent;text-align:match-parent}\n"] }]
        }], propDecorators: { active: [{
                type: Input
            }], url: [{
                type: Input
            }], attributes: [{
                type: Input
            }], linkProps: [{
                type: Input
            }], ariaCurrent: [{
                type: HostBinding,
                args: ['attr.aria-current']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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