import { Component, HostBinding, HostListener, Input, ViewChild } from '@angular/core';
import * as i0 from "@angular/core";
import * as i1 from "../carousel-state";
import * as i2 from "@angular/common";
export class CarouselControlComponent {
    constructor(changeDetector, carouselState) {
        this.changeDetector = changeDetector;
        this.carouselState = carouselState;
        /**
         * Carousel control direction. [docs]
         * @type {'next' | 'prev'}
         */
        this.direction = 'next';
        this.hasContent = true;
    }
    /**
     * Carousel control caption. [docs]
     * @type string
     */
    set caption(value) {
        this._caption = value;
    }
    get caption() {
        return !!this._caption ? this._caption : this.direction === 'prev' ? 'Previous' : 'Next';
    }
    get hostRole() {
        return 'button';
    }
    get hostClasses() {
        return `carousel-control-${this.direction}`;
    }
    get carouselControlIconClass() {
        return `carousel-control-${this.direction}-icon`;
    }
    onKeyUp($event) {
        if ($event.key === 'Enter') {
            this.play();
        }
        if ($event.key === 'ArrowLeft') {
            this.play('prev');
        }
        if ($event.key === 'ArrowRight') {
            this.play('next');
        }
    }
    onClick($event) {
        this.play();
    }
    ngAfterViewInit() {
        this.hasContent = this.content?.nativeElement.childNodes.length ?? false;
        this.changeDetector.detectChanges();
    }
    play(direction = this.direction) {
        const nextIndex = this.carouselState.direction(direction);
        this.carouselState.state = { activeItemIndex: nextIndex };
    }
}
CarouselControlComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselControlComponent, deps: [{ token: i0.ChangeDetectorRef }, { token: i1.CarouselState }], target: i0.ɵɵFactoryTarget.Component });
CarouselControlComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: CarouselControlComponent, selector: "c-carousel-control", inputs: { caption: "caption", direction: "direction" }, host: { listeners: { "keyup": "onKeyUp($event)", "click": "onClick($event)" }, properties: { "attr.role": "this.hostRole", "class": "this.hostClasses" } }, viewQueries: [{ propertyName: "content", first: true, predicate: ["content"], descendants: true }], ngImport: i0, template: "<div #content *ngIf = \"hasContent; else default\"><ng-content></ng-content></div>\n<ng-template #default>\n  <span [class]=\"carouselControlIconClass\" [attr.aria-label]=\"direction\" [attr.aria-hidden]=\"true\"></span>\n  <span class=\"visually-hidden\">{{caption}}</span>\n</ng-template>\n", styles: [""], dependencies: [{ kind: "directive", type: i2.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: CarouselControlComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-carousel-control', template: "<div #content *ngIf = \"hasContent; else default\"><ng-content></ng-content></div>\n<ng-template #default>\n  <span [class]=\"carouselControlIconClass\" [attr.aria-label]=\"direction\" [attr.aria-hidden]=\"true\"></span>\n  <span class=\"visually-hidden\">{{caption}}</span>\n</ng-template>\n" }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i1.CarouselState }]; }, propDecorators: { caption: [{
                type: Input
            }], direction: [{
                type: Input
            }], hostRole: [{
                type: HostBinding,
                args: ['attr.role']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], content: [{
                type: ViewChild,
                args: ['content']
            }], onKeyUp: [{
                type: HostListener,
                args: ['keyup', ['$event']]
            }], onClick: [{
                type: HostListener,
                args: ['click', ['$event']]
            }] } });
//# sourceMappingURL=data:application/json;base64,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