import { Directive, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import * as i0 from "@angular/core";
export class NavLinkDirective {
    constructor() {
        this._cNavLink = true;
        this._disabled = false;
    }
    /**
     * Sets .nav-link class to the host. [docs]
     * @type boolean
     * @default true
     */
    set cNavLink(value) {
        this._cNavLink = coerceBooleanProperty(value);
    }
    ;
    get cNavLink() {
        return this._cNavLink;
    }
    /**
     * Set disabled attr for the host element. [docs]
     * @type boolean
     */
    get disabled() {
        return this._disabled;
    }
    set disabled(value) {
        this._disabled = coerceBooleanProperty(value);
    }
    get ariaCurrent() {
        return this.active ? 'page' : null;
    }
    get isDisabled() {
        return this.disabled || null;
    }
    get attrDisabled() {
        return this.disabled ? '' : null;
    }
    ;
    get getTabindex() {
        return this.disabled ? '-1' : null;
    }
    get getCursorStyle() {
        return this.disabled ? null : 'pointer';
    }
    get hostClasses() {
        return {
            'nav-link': this.cNavLink,
            disabled: this.disabled,
            active: this.active
        };
    }
}
NavLinkDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NavLinkDirective, deps: [], target: i0.ɵɵFactoryTarget.Directive });
NavLinkDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: NavLinkDirective, selector: "[cNavLink]", inputs: { cNavLink: "cNavLink", active: "active", disabled: "disabled" }, host: { properties: { "attr.aria-current": "this.ariaCurrent", "attr.aria-disabled": "this.isDisabled", "attr.disabled": "this.attrDisabled", "attr.tabindex": "this.getTabindex", "style.cursor": "this.getCursorStyle", "class": "this.hostClasses" } }, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: NavLinkDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cNavLink]'
                }]
        }], propDecorators: { cNavLink: [{
                type: Input
            }], active: [{
                type: Input
            }], disabled: [{
                type: Input
            }], ariaCurrent: [{
                type: HostBinding,
                args: ['attr.aria-current']
            }], isDisabled: [{
                type: HostBinding,
                args: ['attr.aria-disabled']
            }], attrDisabled: [{
                type: HostBinding,
                args: ['attr.disabled']
            }], getTabindex: [{
                type: HostBinding,
                args: ['attr.tabindex']
            }], getCursorStyle: [{
                type: HostBinding,
                args: ['style.cursor']
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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