import { Directive, HostBinding, Inject, Input } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { createPopper } from '@popperjs/core';
import { PopoverComponent } from './popover/popover.component';
import { ListenersService } from '../services/listeners.service';
import * as i0 from "@angular/core";
import * as i1 from "../services/listeners.service";
export class PopoverDirective {
    constructor(document, renderer, hostElement, componentFactoryResolver, viewContainerRef, listenersService) {
        this.document = document;
        this.renderer = renderer;
        this.hostElement = hostElement;
        this.componentFactoryResolver = componentFactoryResolver;
        this.viewContainerRef = viewContainerRef;
        this.listenersService = listenersService;
        /**
         * Content of popover
         * @type {string | TemplateRef}
         */
        this.content = '';
        /**
         * Describes the placement of your component after Popper.js has applied all the modifiers that may have flipped or altered the originally provided placement property.
         */
        this.placement = 'top';
        /**
         * Sets which event handlers you’d like provided to your toggle prop. You can specify one trigger or an array of them.
         * @type {'hover' | 'focus' | 'click'}
         */
        this.trigger = 'hover';
        this._visible = false;
        this._popperOptions = {
            modifiers: [
                {
                    name: 'offset',
                    options: {
                        offset: [0, 8],
                    },
                },
            ],
        };
    }
    /**
     * Optional popper Options object, takes precedence over cPopoverPlacement prop
     * @type Partial<Options>
     */
    set popperOptions(value) {
        this._popperOptions = { ...this._popperOptions, placement: this.placement, ...value };
    }
    ;
    get popperOptions() {
        return { placement: this.placement, ...this._popperOptions };
    }
    /**
     * Toggle the visibility of popover component.
     */
    set visible(value) {
        this._visible = value;
    }
    get visible() {
        return this._visible;
    }
    ngOnChanges(changes) {
        if (changes['visible']) {
            changes['visible'].currentValue ? this.addPopoverElement() : this.removePopoverElement();
        }
    }
    get ariaDescribedBy() {
        return this.popoverId ? this.popoverId : null;
    }
    ngOnDestroy() {
        this.clearListeners();
        this.destroyPopoverElement();
    }
    ngOnInit() {
        // this.createPopoverElement();
        this.setListeners();
    }
    setListeners() {
        const config = {
            hostElement: this.hostElement,
            trigger: this.trigger,
            callbackToggle: () => {
                this.visible = !this.visible;
                this.visible ? this.addPopoverElement() : this.removePopoverElement();
            },
            callbackOff: () => {
                this.visible = false;
                this.removePopoverElement();
            },
            callbackOn: () => {
                this.visible = true;
                this.addPopoverElement();
            }
        };
        this.listenersService.setListeners(config);
    }
    clearListeners() {
        this.listenersService.clearListeners();
    }
    getUID(prefix) {
        let uid = prefix ?? 'random-id';
        do {
            uid = `${prefix}-${Math.floor(Math.random() * 1000000).toString(10)}`;
        } while (this.document.getElementById(uid));
        return uid;
    }
    createPopoverElement() {
        if (!this.popoverRef) {
            const popoverComponent = this.componentFactoryResolver.resolveComponentFactory(PopoverComponent);
            this.popoverRef = popoverComponent.create(this.viewContainerRef.injector);
        }
    }
    destroyPopoverElement() {
        this.popover?.remove();
        this.popoverRef?.destroy();
        // @ts-ignore
        this.popoverRef = undefined;
        this.popperInstance?.destroy();
        this.viewContainerRef.detach();
        this.viewContainerRef.clear();
    }
    addPopoverElement() {
        if (!this.popoverRef) {
            this.createPopoverElement();
        }
        this.popoverRef.instance.content = this.content;
        this.popover = this.popoverRef.location.nativeElement;
        this.renderer.addClass(this.popover, 'fade');
        // this.renderer.setStyle(this.popover, 'visibility', 'hidden')
        setTimeout(() => {
            this.popperInstance = createPopper(this.hostElement.nativeElement, this.popover, { ...this.popperOptions });
            this.viewContainerRef.insert(this.popoverRef.hostView);
            setTimeout(() => {
                this.popoverId = this.getUID('popover');
                this.popoverRef.instance.id = this.popoverId;
                this.popoverRef.instance.visible = this.visible;
                // this.renderer.removeStyle(this.popover, 'visibility');
                this.renderer.appendChild(this.document.body, this.popover);
                this.popperInstance.forceUpdate();
                // this.popoverRef.changeDetectorRef.detectChanges();
            }, 100);
        });
    }
    removePopoverElement() {
        if (!this.popoverRef) {
            return;
        }
        this.popoverRef.instance.visible = this.visible;
        // this.popoverRef.changeDetectorRef?.detectChanges();
        this.popoverRef.instance.id = undefined;
        setTimeout(() => {
            this.viewContainerRef.detach();
            // this.viewContainerRef.remove();
            // this.renderer.removeChild(this.document.body, this.popover);
            this.popperInstance?.destroy();
            this.popoverId = '';
        }, 300);
    }
}
PopoverDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: PopoverDirective, deps: [{ token: DOCUMENT }, { token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i0.ComponentFactoryResolver }, { token: i0.ViewContainerRef }, { token: i1.ListenersService }], target: i0.ɵɵFactoryTarget.Directive });
PopoverDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: PopoverDirective, selector: "[cPopover]", inputs: { content: ["cPopover", "content"], popperOptions: ["cPopoverOptions", "popperOptions"], placement: ["cPopoverPlacement", "placement"], trigger: ["cPopoverTrigger", "trigger"], visible: ["cPopoverVisible", "visible"] }, host: { properties: { "attr.aria-describedby": "this.ariaDescribedBy" } }, providers: [ListenersService], exportAs: ["cPopover"], usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: PopoverDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cPopover]',
                    exportAs: 'cPopover',
                    providers: [ListenersService]
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [DOCUMENT]
                }] }, { type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i0.ComponentFactoryResolver }, { type: i0.ViewContainerRef }, { type: i1.ListenersService }]; }, propDecorators: { content: [{
                type: Input,
                args: ['cPopover']
            }], popperOptions: [{
                type: Input,
                args: ['cPopoverOptions']
            }], placement: [{
                type: Input,
                args: ['cPopoverPlacement']
            }], trigger: [{
                type: Input,
                args: ['cPopoverTrigger']
            }], visible: [{
                type: Input,
                args: ['cPopoverVisible']
            }], ariaDescribedBy: [{
                type: HostBinding,
                args: ['attr.aria-describedby']
            }] } });
//# sourceMappingURL=data:application/json;base64,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