import { Component, HostBinding, Input, Optional } from '@angular/core';
import { NavigationEnd } from '@angular/router';
import { SidebarNavHelper } from './sidebar-nav.service';
import { filter } from 'rxjs/operators';
import * as i0 from "@angular/core";
import * as i1 from "../sidebar/sidebar.component";
import * as i2 from "./sidebar-nav.service";
import * as i3 from "@angular/router";
import * as i4 from "../sidebar.service";
import * as i5 from "@angular/common";
import * as i6 from "../../shared/html-attr.directive";
import * as i7 from "./sidebar-nav-divider.component";
import * as i8 from "./sidebar-nav-label.component";
import * as i9 from "./sidebar-nav-link.component";
import * as i10 from "./sidebar-nav-title.component";
import * as i11 from "./sidebar-nav-item-class.pipe";
import * as i12 from "@coreui/icons-angular";
import * as i13 from "./sidebar-nav-badge.pipe";
import * as i14 from "./sidebar-nav-icon.pipe";
export class SidebarNavComponent {
    constructor(sidebar, helper, router, renderer, hostElement, sidebarService) {
        this.sidebar = sidebar;
        this.helper = helper;
        this.router = router;
        this.renderer = renderer;
        this.hostElement = hostElement;
        this.sidebarService = sidebarService;
        this.navItems = [];
        this.dropdownMode = 'closeInactive';
        this.role = 'nav';
        this.navItemsArray = [];
    }
    get hostClasses() {
        return {
            'sidebar-nav': !this.groupItems,
            compact: !this.groupItems && !!this.compact
        };
    }
    get sidebarNavGroupItemsClass() {
        return !!this.groupItems;
    }
    ngOnChanges(changes) {
        this.navItemsArray = Array.isArray(this.navItems) ? this.navItems.slice() : [];
    }
    hideMobile() {
        // todo: proper scrollIntoView() after NavigationEnd
        if (this.sidebar && this.sidebar.sidebarState.mobile) {
            this.sidebarService.toggle({ toggle: 'visible', sidebar: this.sidebar });
        }
    }
}
SidebarNavComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavComponent, deps: [{ token: i1.SidebarComponent, optional: true }, { token: i2.SidebarNavHelper }, { token: i3.Router }, { token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i4.SidebarService }], target: i0.ɵɵFactoryTarget.Component });
SidebarNavComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: SidebarNavComponent, selector: "c-sidebar-nav", inputs: { navItems: "navItems", dropdownMode: "dropdownMode", groupItems: "groupItems", compact: "compact" }, host: { properties: { "class": "this.hostClasses", "class.nav-group-items": "this.sidebarNavGroupItemsClass", "attr.role": "this.role" } }, usesOnChanges: true, ngImport: i0, template: "<ng-container *ngFor=\"let item of navItemsArray\">\r\n  <ng-container [ngSwitch]=\"helper.itemType(item)\">\r\n    <c-sidebar-nav-group\r\n      *ngSwitchCase=\"'group'\"\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\"\r\n      routerLinkActive=\"show\"\r\n      #rla=\"routerLinkActive\"\r\n      [routerLinkActiveOptions]=\"{exact: true}\"\r\n    >\r\n    </c-sidebar-nav-group>\r\n    <c-sidebar-nav-divider\r\n      *ngSwitchCase=\"'divider'\"\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\"\r\n      [cHtmlAttr]=\"item.attributes ?? {}\">\r\n    </c-sidebar-nav-divider>\r\n    <c-sidebar-nav-title\r\n      *ngSwitchCase=\"'title'\"\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\"\r\n      [cHtmlAttr]=\"item.attributes ?? {}\">\r\n    </c-sidebar-nav-title>\r\n    <c-sidebar-nav-label\r\n      *ngSwitchCase=\"'label'\"\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\">\r\n    </c-sidebar-nav-label>\r\n    <ng-container\r\n      *ngSwitchCase=\"'empty'\">\r\n    </ng-container>\r\n    <c-sidebar-nav-link\r\n      *ngSwitchDefault\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\"\r\n      (linkClick)=\"hideMobile()\"\r\n    >\r\n    </c-sidebar-nav-link>\r\n  </ng-container>\r\n</ng-container>\r\n<ng-content></ng-content>\r\n", styles: [""], dependencies: [{ kind: "directive", type: i0.forwardRef(function () { return i5.NgClass; }), selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i0.forwardRef(function () { return i5.NgForOf; }), selector: "[ngFor][ngForOf]", inputs: ["ngForOf", "ngForTrackBy", "ngForTemplate"] }, { kind: "directive", type: i0.forwardRef(function () { return i5.NgSwitch; }), selector: "[ngSwitch]", inputs: ["ngSwitch"] }, { kind: "directive", type: i0.forwardRef(function () { return i5.NgSwitchCase; }), selector: "[ngSwitchCase]", inputs: ["ngSwitchCase"] }, { kind: "directive", type: i0.forwardRef(function () { return i5.NgSwitchDefault; }), selector: "[ngSwitchDefault]" }, { kind: "directive", type: i0.forwardRef(function () { return i3.RouterLinkActive; }), selector: "[routerLinkActive]", inputs: ["routerLinkActiveOptions", "ariaCurrentWhenActive", "routerLinkActive"], outputs: ["isActiveChange"], exportAs: ["routerLinkActive"] }, { kind: "directive", type: i0.forwardRef(function () { return i6.HtmlAttributesDirective; }), selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }, { kind: "component", type: i0.forwardRef(function () { return i7.SidebarNavDividerComponent; }), selector: "c-sidebar-nav-divider", inputs: ["item"] }, { kind: "component", type: i0.forwardRef(function () { return SidebarNavGroupComponent; }), selector: "c-sidebar-nav-group", inputs: ["item", "dropdownMode", "show"] }, { kind: "component", type: i0.forwardRef(function () { return i8.SidebarNavLabelComponent; }), selector: "c-sidebar-nav-label", inputs: ["item"] }, { kind: "component", type: i0.forwardRef(function () { return i9.SidebarNavLinkComponent; }), selector: "c-sidebar-nav-link", inputs: ["item"], outputs: ["linkClick"] }, { kind: "component", type: i0.forwardRef(function () { return i10.SidebarNavTitleComponent; }), selector: "c-sidebar-nav-title", inputs: ["item"] }, { kind: "pipe", type: i0.forwardRef(function () { return i11.SidebarNavItemClassPipe; }), name: "cSidebarNavItemClass" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-sidebar-nav', template: "<ng-container *ngFor=\"let item of navItemsArray\">\r\n  <ng-container [ngSwitch]=\"helper.itemType(item)\">\r\n    <c-sidebar-nav-group\r\n      *ngSwitchCase=\"'group'\"\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\"\r\n      routerLinkActive=\"show\"\r\n      #rla=\"routerLinkActive\"\r\n      [routerLinkActiveOptions]=\"{exact: true}\"\r\n    >\r\n    </c-sidebar-nav-group>\r\n    <c-sidebar-nav-divider\r\n      *ngSwitchCase=\"'divider'\"\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\"\r\n      [cHtmlAttr]=\"item.attributes ?? {}\">\r\n    </c-sidebar-nav-divider>\r\n    <c-sidebar-nav-title\r\n      *ngSwitchCase=\"'title'\"\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\"\r\n      [cHtmlAttr]=\"item.attributes ?? {}\">\r\n    </c-sidebar-nav-title>\r\n    <c-sidebar-nav-label\r\n      *ngSwitchCase=\"'label'\"\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\">\r\n    </c-sidebar-nav-label>\r\n    <ng-container\r\n      *ngSwitchCase=\"'empty'\">\r\n    </ng-container>\r\n    <c-sidebar-nav-link\r\n      *ngSwitchDefault\r\n      [item]=\"item\"\r\n      [ngClass]=\"item | cSidebarNavItemClass\"\r\n      (linkClick)=\"hideMobile()\"\r\n    >\r\n    </c-sidebar-nav-link>\r\n  </ng-container>\r\n</ng-container>\r\n<ng-content></ng-content>\r\n" }]
        }], ctorParameters: function () { return [{ type: i1.SidebarComponent, decorators: [{
                    type: Optional
                }] }, { type: i2.SidebarNavHelper }, { type: i3.Router }, { type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i4.SidebarService }]; }, propDecorators: { navItems: [{
                type: Input
            }], dropdownMode: [{
                type: Input
            }], groupItems: [{
                type: Input
            }], compact: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }], sidebarNavGroupItemsClass: [{
                type: HostBinding,
                args: ['class.nav-group-items']
            }], role: [{
                type: HostBinding,
                args: ['attr.role']
            }] } });
export class SidebarNavGroupComponent {
    constructor(router, helper, hostElement) {
        this.router = router;
        this.helper = helper;
        this.hostElement = hostElement;
        this.dropdownMode = 'closeInactive';
        this.navItems = [];
        this.navigationEndObservable = router.events.pipe(filter((event) => event instanceof NavigationEnd));
    }
    get hostClasses() {
        return {
            'nav-group': true,
            show: this.open,
        };
    }
    ngOnInit() {
        this.navItems = [...this.item.children];
        this.navSubscription = this.navigationEndObservable.subscribe((event) => {
            const samePath = this.samePath(event.url);
            this.openGroup(samePath);
        });
        if (this.samePath(this.router.routerState.snapshot.url)) {
            this.openGroup(true);
        }
    }
    samePath(url) {
        // console.log('item:', this.item.name, this.item.url, 'url:', url);
        const itemArray = this.item.url?.split('/');
        const urlArray = url.split('/');
        return itemArray?.every((value, index) => {
            // console.log(value === urlArray[index], 'value:', value, 'index:', index, urlArray[index], url);
            return value === urlArray[index];
        });
    }
    openGroup(open) {
        this.open = open;
    }
    toggleGroup($event) {
        $event.preventDefault();
        this.open = !this.open;
    }
    ngOnDestroy() {
        this.navSubscription.unsubscribe();
    }
}
SidebarNavGroupComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavGroupComponent, deps: [{ token: i3.Router }, { token: i2.SidebarNavHelper }, { token: i0.ElementRef }], target: i0.ɵɵFactoryTarget.Component });
SidebarNavGroupComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: SidebarNavGroupComponent, selector: "c-sidebar-nav-group", inputs: { item: "item", dropdownMode: "dropdownMode", show: "show" }, host: { properties: { "class": "this.hostClasses" } }, providers: [SidebarNavHelper], ngImport: i0, template: "<a class=\"nav-link nav-group-toggle\"\r\n   (click)=\"toggleGroup($event)\"\r\n   [cHtmlAttr]=\"item.attributes\">\r\n  <ng-container *ngTemplateOutlet=\"iconTemplate ; context: {$implicit: item}\"></ng-container>\r\n  <ng-container>{{ item.name }}</ng-container>\r\n  <span *ngIf=\"helper.hasBadge(item)\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge.text }}</span>\r\n</a>\r\n<c-sidebar-nav\r\n  [groupItems]=\"true\"\r\n  [navItems]=\"navItems\">\r\n</c-sidebar-nav>\r\n\r\n<ng-template #iconTemplate let-item>\r\n  <i *ngIf=\"item?.icon\" [ngClass]=\"item | cSidebarNavIcon\"></i>\r\n  <ng-template [ngIf]=\"item?.iconComponent\">\r\n    <svg\r\n      [cIcon]=\"item.iconComponent?.content\"\r\n      [name]=\"item.iconComponent?.name\"\r\n      [customClasses]=\"item | cSidebarNavIcon\"\r\n    ></svg>\r\n  </ng-template>\r\n  <span *ngIf=\"!item?.icon && !item?.iconComponent\" [ngClass]=\"item | cSidebarNavIcon\"></span>\r\n</ng-template>\r\n", styles: [".nav-group-toggle{cursor:pointer}.nav-group-items{display:block}\n"], dependencies: [{ kind: "directive", type: i5.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i5.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "directive", type: i5.NgTemplateOutlet, selector: "[ngTemplateOutlet]", inputs: ["ngTemplateOutletContext", "ngTemplateOutlet", "ngTemplateOutletInjector"] }, { kind: "directive", type: i6.HtmlAttributesDirective, selector: "[cHtmlAttr]", inputs: ["cHtmlAttr"], exportAs: ["cHtmlAttr"] }, { kind: "directive", type: i12.IconDirective, selector: "svg[cIcon]", inputs: ["cIcon", "size", "title", "customClasses", "width", "height", "name", "viewBox", "xmlns", "pointer-events", "role"], exportAs: ["cIcon"] }, { kind: "component", type: SidebarNavComponent, selector: "c-sidebar-nav", inputs: ["navItems", "dropdownMode", "groupItems", "compact"] }, { kind: "pipe", type: i13.SidebarNavBadgePipe, name: "cSidebarNavBadge" }, { kind: "pipe", type: i14.SidebarNavIconPipe, name: "cSidebarNavIcon" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: SidebarNavGroupComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-sidebar-nav-group', providers: [SidebarNavHelper], template: "<a class=\"nav-link nav-group-toggle\"\r\n   (click)=\"toggleGroup($event)\"\r\n   [cHtmlAttr]=\"item.attributes\">\r\n  <ng-container *ngTemplateOutlet=\"iconTemplate ; context: {$implicit: item}\"></ng-container>\r\n  <ng-container>{{ item.name }}</ng-container>\r\n  <span *ngIf=\"helper.hasBadge(item)\" [ngClass]=\"item | cSidebarNavBadge\">{{ item.badge.text }}</span>\r\n</a>\r\n<c-sidebar-nav\r\n  [groupItems]=\"true\"\r\n  [navItems]=\"navItems\">\r\n</c-sidebar-nav>\r\n\r\n<ng-template #iconTemplate let-item>\r\n  <i *ngIf=\"item?.icon\" [ngClass]=\"item | cSidebarNavIcon\"></i>\r\n  <ng-template [ngIf]=\"item?.iconComponent\">\r\n    <svg\r\n      [cIcon]=\"item.iconComponent?.content\"\r\n      [name]=\"item.iconComponent?.name\"\r\n      [customClasses]=\"item | cSidebarNavIcon\"\r\n    ></svg>\r\n  </ng-template>\r\n  <span *ngIf=\"!item?.icon && !item?.iconComponent\" [ngClass]=\"item | cSidebarNavIcon\"></span>\r\n</ng-template>\r\n", styles: [".nav-group-toggle{cursor:pointer}.nav-group-items{display:block}\n"] }]
        }], ctorParameters: function () { return [{ type: i3.Router }, { type: i2.SidebarNavHelper }, { type: i0.ElementRef }]; }, propDecorators: { item: [{
                type: Input
            }], dropdownMode: [{
                type: Input
            }], show: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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