import { ChangeDetectionStrategy, Component, ContentChildren, EventEmitter, HostBinding, Input, Output } from '@angular/core';
import { coerceNumberProperty } from '@angular/cdk/coercion';
import { TabPaneComponent } from '../tab-pane/tab-pane.component';
import * as i0 from "@angular/core";
import * as i1 from "../tab.service";
export class TabContentComponent {
    constructor(changeDetectorRef, tabService) {
        this.changeDetectorRef = changeDetectorRef;
        this.tabService = tabService;
        this._activeTabPaneIdx = -1;
        /**
         * Event emited on the active tab pane index change.
         */
        this.activeTabPaneIdxChange = new EventEmitter();
    }
    /**
     * Set active tabPane index
     * @type number
     */
    set activeTabPaneIdx(value) {
        const newValue = coerceNumberProperty(value);
        if (this._activeTabPaneIdx != newValue) {
            this._activeTabPaneIdx = newValue;
            this.activeTabPaneIdxChange.emit(newValue);
            this.changeDetectorRef.markForCheck();
            this.changeDetectorRef.detectChanges();
        }
    }
    ;
    get activeTabPaneIdx() {
        return this._activeTabPaneIdx;
    }
    get hostClasses() {
        return {
            'tab-content': true
        };
    }
    ngAfterContentInit() {
        this.subscribeTabService();
    }
    ngAfterContentChecked() {
        this.panes?.forEach((tabPane, index) => {
            tabPane.tabContent = this;
            tabPane.tabPaneIdx = index;
        });
        this.refreshTabPaneActive(this.activeTabPaneIdx);
        this.tabService.setActiveTabIdx({ tabContent: this, activeIdx: this.activeTabPaneIdx });
    }
    ngOnChanges(changes) {
        if (changes['activeTabPaneIdx']?.currentValue) {
            this.tabService.setActiveTabIdx({ tabContent: this, activeIdx: changes['activeTabPaneIdx'].currentValue });
        }
    }
    ngOnDestroy() {
        this.subscribeTabService(false);
    }
    subscribeTabService(subscribe = true) {
        if (subscribe) {
            this.tabServiceSubscription = this.tabService.activeTabPaneIdx$.subscribe((tabContentState) => {
                if (this === tabContentState.tabContent) {
                    this.activeTabPaneIdx = tabContentState.activeIdx;
                }
            });
        }
        else {
            this.tabServiceSubscription.unsubscribe();
        }
    }
    refreshTabPaneActive(idx) {
        // hack for active state pane refresh todo?
        this.panes?.forEach((tabPane, index) => {
            tabPane.active = idx === index;
        });
    }
}
TabContentComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: TabContentComponent, deps: [{ token: i0.ChangeDetectorRef }, { token: i1.TabService }], target: i0.ɵɵFactoryTarget.Component });
TabContentComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: TabContentComponent, selector: "c-tab-content", inputs: { activeTabPaneIdx: "activeTabPaneIdx" }, outputs: { activeTabPaneIdxChange: "activeTabPaneIdxChange" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "panes", predicate: TabPaneComponent }], exportAs: ["cTabContent"], usesOnChanges: true, ngImport: i0, template: "<ng-content></ng-content>\n", styles: [":host{display:block}\n"], changeDetection: i0.ChangeDetectionStrategy.OnPush });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: TabContentComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-tab-content', changeDetection: ChangeDetectionStrategy.OnPush, exportAs: 'cTabContent', template: "<ng-content></ng-content>\n", styles: [":host{display:block}\n"] }]
        }], ctorParameters: function () { return [{ type: i0.ChangeDetectorRef }, { type: i1.TabService }]; }, propDecorators: { activeTabPaneIdx: [{
                type: Input
            }], activeTabPaneIdxChange: [{
                type: Output
            }], panes: [{
                type: ContentChildren,
                args: [TabPaneComponent]
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidGFiLWNvbnRlbnQuY29tcG9uZW50LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vLi4vLi4vcHJvamVjdHMvY29yZXVpLWFuZ3VsYXIvc3JjL2xpYi90YWJzL3RhYi1jb250ZW50L3RhYi1jb250ZW50LmNvbXBvbmVudC50cyIsIi4uLy4uLy4uLy4uLy4uLy4uL3Byb2plY3RzL2NvcmV1aS1hbmd1bGFyL3NyYy9saWIvdGFicy90YWItY29udGVudC90YWItY29udGVudC5jb21wb25lbnQuaHRtbCJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiQUFBQSxPQUFPLEVBR0wsdUJBQXVCLEVBRXZCLFNBQVMsRUFDVCxlQUFlLEVBQ2YsWUFBWSxFQUNaLFdBQVcsRUFDWCxLQUFLLEVBR0wsTUFBTSxFQUdQLE1BQU0sZUFBZSxDQUFDO0FBQ3ZCLE9BQU8sRUFBRSxvQkFBb0IsRUFBRSxNQUFNLHVCQUF1QixDQUFDO0FBRzdELE9BQU8sRUFBRSxnQkFBZ0IsRUFBRSxNQUFNLGdDQUFnQyxDQUFDOzs7QUFVbEUsTUFBTSxPQUFPLG1CQUFtQjtJQTZCOUIsWUFDVSxpQkFBb0MsRUFDcEMsVUFBc0I7UUFEdEIsc0JBQWlCLEdBQWpCLGlCQUFpQixDQUFtQjtRQUNwQyxlQUFVLEdBQVYsVUFBVSxDQUFZO1FBWnhCLHNCQUFpQixHQUFHLENBQUMsQ0FBQyxDQUFDO1FBRS9COztXQUVHO1FBQ08sMkJBQXNCLEdBQXlCLElBQUksWUFBWSxFQUFVLENBQUM7SUFRaEYsQ0FBQztJQTlCTDs7O09BR0c7SUFDSCxJQUNJLGdCQUFnQixDQUFDLEtBQWE7UUFDaEMsTUFBTSxRQUFRLEdBQUcsb0JBQW9CLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDN0MsSUFBSSxJQUFJLENBQUMsaUJBQWlCLElBQUksUUFBUSxFQUFFO1lBQ3RDLElBQUksQ0FBQyxpQkFBaUIsR0FBRyxRQUFRLENBQUM7WUFDbEMsSUFBSSxDQUFDLHNCQUFzQixDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsQ0FBQztZQUMzQyxJQUFJLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDdEMsSUFBSSxDQUFDLGlCQUFpQixDQUFDLGFBQWEsRUFBRSxDQUFDO1NBQ3hDO0lBQ0gsQ0FBQztJQUFBLENBQUM7SUFDRixJQUFJLGdCQUFnQjtRQUNsQixPQUFPLElBQUksQ0FBQyxpQkFBaUIsQ0FBQztJQUNoQyxDQUFDO0lBZ0JELElBQ0ksV0FBVztRQUNiLE9BQU87WUFDTCxhQUFhLEVBQUUsSUFBSTtTQUNwQixDQUFDO0lBQ0osQ0FBQztJQUVELGtCQUFrQjtRQUNoQixJQUFJLENBQUMsbUJBQW1CLEVBQUUsQ0FBQztJQUM3QixDQUFDO0lBRUQscUJBQXFCO1FBQ25CLElBQUksQ0FBQyxLQUFLLEVBQUUsT0FBTyxDQUFDLENBQUMsT0FBTyxFQUFFLEtBQUssRUFBRSxFQUFFO1lBQ3JDLE9BQU8sQ0FBQyxVQUFVLEdBQUcsSUFBSSxDQUFDO1lBQ3hCLE9BQU8sQ0FBQyxVQUFVLEdBQUcsS0FBSyxDQUFDO1FBQy9CLENBQUMsQ0FBQyxDQUFDO1FBQ0gsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDO1FBQ2pELElBQUksQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLEVBQUUsVUFBVSxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLGdCQUFnQixFQUFFLENBQUMsQ0FBQztJQUMxRixDQUFDO0lBRUQsV0FBVyxDQUFDLE9BQXNCO1FBQ2hDLElBQUksT0FBTyxDQUFDLGtCQUFrQixDQUFDLEVBQUUsWUFBWSxFQUFFO1lBQzdDLElBQUksQ0FBQyxVQUFVLENBQUMsZUFBZSxDQUFDLEVBQUUsVUFBVSxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsT0FBTyxDQUFDLGtCQUFrQixDQUFDLENBQUMsWUFBWSxFQUFFLENBQUMsQ0FBQztTQUM1RztJQUNILENBQUM7SUFFRCxXQUFXO1FBQ1QsSUFBSSxDQUFDLG1CQUFtQixDQUFDLEtBQUssQ0FBQyxDQUFDO0lBQ2xDLENBQUM7SUFFRCxtQkFBbUIsQ0FBQyxZQUFxQixJQUFJO1FBQzNDLElBQUksU0FBUyxFQUFFO1lBQ2IsSUFBSSxDQUFDLHNCQUFzQixHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsU0FBUyxDQUFDLENBQUMsZUFBZSxFQUFFLEVBQUU7Z0JBQzVGLElBQUksSUFBSSxLQUFLLGVBQWUsQ0FBQyxVQUFVLEVBQUU7b0JBQ3ZDLElBQUksQ0FBQyxnQkFBZ0IsR0FBRyxlQUFlLENBQUMsU0FBUyxDQUFDO2lCQUNuRDtZQUNILENBQUMsQ0FBQyxDQUFDO1NBQ0o7YUFBTTtZQUNMLElBQUksQ0FBQyxzQkFBc0IsQ0FBQyxXQUFXLEVBQUUsQ0FBQztTQUMzQztJQUNILENBQUM7SUFFRCxvQkFBb0IsQ0FBQyxHQUFXO1FBQzlCLDJDQUEyQztRQUMzQyxJQUFJLENBQUMsS0FBSyxFQUFFLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFBRSxLQUFLLEVBQUUsRUFBRTtZQUNyQyxPQUFPLENBQUMsTUFBTSxHQUFHLEdBQUcsS0FBSyxLQUFLLENBQUM7UUFDakMsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDOztnSEFqRlUsbUJBQW1CO29HQUFuQixtQkFBbUIsbVBBMEJiLGdCQUFnQiw2RUN2RG5DLDZCQUNBOzJGRDRCYSxtQkFBbUI7a0JBUC9CLFNBQVM7K0JBQ0UsZUFBZSxtQkFHUix1QkFBdUIsQ0FBQyxNQUFNLFlBQ3JDLGFBQWE7aUlBU25CLGdCQUFnQjtzQkFEbkIsS0FBSztnQkFrQkksc0JBQXNCO3NCQUEvQixNQUFNO2dCQUVtQyxLQUFLO3NCQUE5QyxlQUFlO3VCQUFDLGdCQUFnQjtnQkFTN0IsV0FBVztzQkFEZCxXQUFXO3VCQUFDLE9BQU8iLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQge1xyXG4gIEFmdGVyQ29udGVudENoZWNrZWQsXHJcbiAgQWZ0ZXJDb250ZW50SW5pdCxcclxuICBDaGFuZ2VEZXRlY3Rpb25TdHJhdGVneSxcclxuICBDaGFuZ2VEZXRlY3RvclJlZixcclxuICBDb21wb25lbnQsXHJcbiAgQ29udGVudENoaWxkcmVuLFxyXG4gIEV2ZW50RW1pdHRlcixcclxuICBIb3N0QmluZGluZyxcclxuICBJbnB1dCxcclxuICBPbkNoYW5nZXMsXHJcbiAgT25EZXN0cm95LFxyXG4gIE91dHB1dCxcclxuICBRdWVyeUxpc3QsXHJcbiAgU2ltcGxlQ2hhbmdlc1xyXG59IGZyb20gJ0Bhbmd1bGFyL2NvcmUnO1xyXG5pbXBvcnQgeyBjb2VyY2VOdW1iZXJQcm9wZXJ0eSB9IGZyb20gJ0Bhbmd1bGFyL2Nkay9jb2VyY2lvbic7XHJcbmltcG9ydCB7IFN1YnNjcmlwdGlvbiB9IGZyb20gJ3J4anMnO1xyXG5cclxuaW1wb3J0IHsgVGFiUGFuZUNvbXBvbmVudCB9IGZyb20gJy4uL3RhYi1wYW5lL3RhYi1wYW5lLmNvbXBvbmVudCc7XHJcbmltcG9ydCB7IFRhYlNlcnZpY2UgfSBmcm9tICcuLi90YWIuc2VydmljZSc7XHJcblxyXG5AQ29tcG9uZW50KHtcclxuICBzZWxlY3RvcjogJ2MtdGFiLWNvbnRlbnQnLFxyXG4gIHRlbXBsYXRlVXJsOiAnLi90YWItY29udGVudC5jb21wb25lbnQuaHRtbCcsXHJcbiAgc3R5bGVVcmxzOiBbJy4vdGFiLWNvbnRlbnQuY29tcG9uZW50LnNjc3MnXSxcclxuICBjaGFuZ2VEZXRlY3Rpb246IENoYW5nZURldGVjdGlvblN0cmF0ZWd5Lk9uUHVzaCxcclxuICBleHBvcnRBczogJ2NUYWJDb250ZW50J1xyXG59KVxyXG5leHBvcnQgY2xhc3MgVGFiQ29udGVudENvbXBvbmVudCBpbXBsZW1lbnRzIEFmdGVyQ29udGVudENoZWNrZWQsIEFmdGVyQ29udGVudEluaXQsIE9uQ2hhbmdlcywgT25EZXN0cm95IHtcclxuXHJcbiAgLyoqXHJcbiAgICogU2V0IGFjdGl2ZSB0YWJQYW5lIGluZGV4XHJcbiAgICogQHR5cGUgbnVtYmVyXHJcbiAgICovXHJcbiAgQElucHV0KClcclxuICBzZXQgYWN0aXZlVGFiUGFuZUlkeCh2YWx1ZTogbnVtYmVyKSB7XHJcbiAgICBjb25zdCBuZXdWYWx1ZSA9IGNvZXJjZU51bWJlclByb3BlcnR5KHZhbHVlKTtcclxuICAgIGlmICh0aGlzLl9hY3RpdmVUYWJQYW5lSWR4ICE9IG5ld1ZhbHVlKSB7XHJcbiAgICAgIHRoaXMuX2FjdGl2ZVRhYlBhbmVJZHggPSBuZXdWYWx1ZTtcclxuICAgICAgdGhpcy5hY3RpdmVUYWJQYW5lSWR4Q2hhbmdlLmVtaXQobmV3VmFsdWUpO1xyXG4gICAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLm1hcmtGb3JDaGVjaygpO1xyXG4gICAgICB0aGlzLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcclxuICAgIH1cclxuICB9O1xyXG4gIGdldCBhY3RpdmVUYWJQYW5lSWR4KCkge1xyXG4gICAgcmV0dXJuIHRoaXMuX2FjdGl2ZVRhYlBhbmVJZHg7XHJcbiAgfVxyXG4gIHByaXZhdGUgX2FjdGl2ZVRhYlBhbmVJZHggPSAtMTtcclxuXHJcbiAgLyoqXHJcbiAgICogRXZlbnQgZW1pdGVkIG9uIHRoZSBhY3RpdmUgdGFiIHBhbmUgaW5kZXggY2hhbmdlLlxyXG4gICAqL1xyXG4gIEBPdXRwdXQoKSBhY3RpdmVUYWJQYW5lSWR4Q2hhbmdlOiBFdmVudEVtaXR0ZXI8bnVtYmVyPiA9IG5ldyBFdmVudEVtaXR0ZXI8bnVtYmVyPigpO1xyXG5cclxuICBAQ29udGVudENoaWxkcmVuKFRhYlBhbmVDb21wb25lbnQpIHB1YmxpYyBwYW5lcyE6IFF1ZXJ5TGlzdDxUYWJQYW5lQ29tcG9uZW50PjtcclxuICBwcml2YXRlIHRhYlNlcnZpY2VTdWJzY3JpcHRpb24hOiBTdWJzY3JpcHRpb247XHJcblxyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgcHJpdmF0ZSBjaGFuZ2VEZXRlY3RvclJlZjogQ2hhbmdlRGV0ZWN0b3JSZWYsXHJcbiAgICBwcml2YXRlIHRhYlNlcnZpY2U6IFRhYlNlcnZpY2VcclxuICApIHsgfVxyXG5cclxuICBASG9zdEJpbmRpbmcoJ2NsYXNzJylcclxuICBnZXQgaG9zdENsYXNzZXMoKSB7XHJcbiAgICByZXR1cm4ge1xyXG4gICAgICAndGFiLWNvbnRlbnQnOiB0cnVlXHJcbiAgICB9O1xyXG4gIH1cclxuXHJcbiAgbmdBZnRlckNvbnRlbnRJbml0KCk6IHZvaWQge1xyXG4gICAgdGhpcy5zdWJzY3JpYmVUYWJTZXJ2aWNlKCk7XHJcbiAgfVxyXG5cclxuICBuZ0FmdGVyQ29udGVudENoZWNrZWQoKTogdm9pZCB7XHJcbiAgICB0aGlzLnBhbmVzPy5mb3JFYWNoKCh0YWJQYW5lLCBpbmRleCkgPT4ge1xyXG4gICAgICB0YWJQYW5lLnRhYkNvbnRlbnQgPSB0aGlzO1xyXG4gICAgICAgIHRhYlBhbmUudGFiUGFuZUlkeCA9IGluZGV4O1xyXG4gICAgfSk7XHJcbiAgICB0aGlzLnJlZnJlc2hUYWJQYW5lQWN0aXZlKHRoaXMuYWN0aXZlVGFiUGFuZUlkeCk7XHJcbiAgICB0aGlzLnRhYlNlcnZpY2Uuc2V0QWN0aXZlVGFiSWR4KHsgdGFiQ29udGVudDogdGhpcywgYWN0aXZlSWR4OiB0aGlzLmFjdGl2ZVRhYlBhbmVJZHggfSk7XHJcbiAgfVxyXG5cclxuICBuZ09uQ2hhbmdlcyhjaGFuZ2VzOiBTaW1wbGVDaGFuZ2VzKTogdm9pZCB7XHJcbiAgICBpZiAoY2hhbmdlc1snYWN0aXZlVGFiUGFuZUlkeCddPy5jdXJyZW50VmFsdWUpIHtcclxuICAgICAgdGhpcy50YWJTZXJ2aWNlLnNldEFjdGl2ZVRhYklkeCh7IHRhYkNvbnRlbnQ6IHRoaXMsIGFjdGl2ZUlkeDogY2hhbmdlc1snYWN0aXZlVGFiUGFuZUlkeCddLmN1cnJlbnRWYWx1ZSB9KTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIG5nT25EZXN0cm95KCk6IHZvaWQge1xyXG4gICAgdGhpcy5zdWJzY3JpYmVUYWJTZXJ2aWNlKGZhbHNlKTtcclxuICB9XHJcblxyXG4gIHN1YnNjcmliZVRhYlNlcnZpY2Uoc3Vic2NyaWJlOiBib29sZWFuID0gdHJ1ZSkge1xyXG4gICAgaWYgKHN1YnNjcmliZSkge1xyXG4gICAgICB0aGlzLnRhYlNlcnZpY2VTdWJzY3JpcHRpb24gPSB0aGlzLnRhYlNlcnZpY2UuYWN0aXZlVGFiUGFuZUlkeCQuc3Vic2NyaWJlKCh0YWJDb250ZW50U3RhdGUpID0+IHtcclxuICAgICAgICBpZiAodGhpcyA9PT0gdGFiQ29udGVudFN0YXRlLnRhYkNvbnRlbnQpIHtcclxuICAgICAgICAgIHRoaXMuYWN0aXZlVGFiUGFuZUlkeCA9IHRhYkNvbnRlbnRTdGF0ZS5hY3RpdmVJZHg7XHJcbiAgICAgICAgfVxyXG4gICAgICB9KTtcclxuICAgIH0gZWxzZSB7XHJcbiAgICAgIHRoaXMudGFiU2VydmljZVN1YnNjcmlwdGlvbi51bnN1YnNjcmliZSgpO1xyXG4gICAgfVxyXG4gIH1cclxuXHJcbiAgcmVmcmVzaFRhYlBhbmVBY3RpdmUoaWR4OiBudW1iZXIpIHtcclxuICAgIC8vIGhhY2sgZm9yIGFjdGl2ZSBzdGF0ZSBwYW5lIHJlZnJlc2ggdG9kbz9cclxuICAgIHRoaXMucGFuZXM/LmZvckVhY2goKHRhYlBhbmUsIGluZGV4KSA9PiB7XHJcbiAgICAgIHRhYlBhbmUuYWN0aXZlID0gaWR4ID09PSBpbmRleDtcclxuICAgIH0pO1xyXG4gIH1cclxufVxyXG4iLCI8bmctY29udGVudD48L25nLWNvbnRlbnQ+XG4iXX0=