import { Component, ContentChildren, HostBinding, Input, VERSION, ViewChild, ViewContainerRef } from '@angular/core';
import { ToasterHostDirective } from './toaster-host.directive';
import { ToastComponent } from '../toast/toast.component';
import * as i0 from "@angular/core";
import * as i1 from "./toaster.service";
import * as i2 from "./toaster-host.directive";
export var ToasterPlacement;
(function (ToasterPlacement) {
    ToasterPlacement["Static"] = "static";
    ToasterPlacement["TopStart"] = "top-start";
    ToasterPlacement["TopCenter"] = "top-center";
    ToasterPlacement["TopEnd"] = "top-end";
    ToasterPlacement["MiddleStart"] = "middle-start";
    ToasterPlacement["MiddleCenter"] = "middle-center";
    ToasterPlacement["MiddleEnd"] = "middle-end";
    ToasterPlacement["BottomStart"] = "bottom-start";
    ToasterPlacement["BottomCenter"] = "bottom-center";
    ToasterPlacement["BottomEnd"] = "bottom-end";
})(ToasterPlacement || (ToasterPlacement = {}));
export class ToasterComponent {
    constructor(componentFactoryResolver, hostElement, renderer, toasterService) {
        this.componentFactoryResolver = componentFactoryResolver;
        this.hostElement = hostElement;
        this.renderer = renderer;
        this.toasterService = toasterService;
        this.placements = Object.values(ToasterPlacement);
        this.toastsDynamic = [];
        /**
         * Toaster placement
         * @type TToasterPlacement
         */
        this.placement = ToasterPlacement.TopEnd;
        /**
         * Toaster position
         * @type (string | 'absolute' | 'fixed' | 'static')
         */
        this.position = 'absolute';
    }
    get hostClasses() {
        return {
            toaster: true,
            'toast-container': true,
            [`position-${this.position}`]: !!this.position,
            'top-0': this.placement.includes('top'),
            'top-50': this.placement.includes('middle'),
            'bottom-0': this.placement.includes('bottom'),
            'start-0': this.placement.includes('start'),
            'start-50': this.placement.includes('center'),
            'end-0': this.placement.includes('end'),
            'translate-middle-x': this.placement.includes('center') && !this.placement.includes('middle'),
            'translate-middle-y': this.placement.includes('middle') && !this.placement.includes('center'),
            'translate-middle': this.placement.includes('middle') && this.placement.includes('center'),
        };
    }
    ngOnInit() {
        this.stateToasterSubscribe(true);
    }
    ngOnDestroy() {
        this.stateToasterSubscribe(false);
    }
    ngAfterContentChecked() {
        this.toasts = this.contentToasts;
    }
    addToast(toast, props, options) {
        let componentRef;
        if (parseInt(VERSION.major) < 13) {
            const factory = this.componentFactoryResolver.resolveComponentFactory(toast);
            componentRef = this.toasterHost.viewContainerRef.createComponent(factory, options?.index, options?.injector, options?.projectableNodes, options?.ngModuleRef);
        }
        else {
            // @ts-ignore
            componentRef = this.toasterHost.viewContainerRef.createComponent(toast, options);
        }
        this.toastsDynamic.push(componentRef);
        const index = this.toastsDynamic.indexOf(componentRef);
        for (const [key, value] of Object.entries(props)) {
            componentRef.instance[key] = value;
        }
        componentRef.instance['placement'] = this.placement;
        componentRef.instance['dynamic'] = true;
        componentRef.instance['index'] = index;
        componentRef.instance['visible'] = true;
        componentRef.instance['visibleChange'].emit(true);
        componentRef.changeDetectorRef?.detectChanges();
        return componentRef;
    }
    removeToast(state) {
        this.toastsDynamic?.forEach(item => {
            if (state.toast?.dynamic && (item.instance === state.toast)) {
                item.instance.visible = false;
                item.instance['visibleChange'].emit(false);
                setTimeout(() => {
                    item.destroy();
                }, 300);
            }
        });
        this.toasts?.forEach(item => {
            if (item.element.nativeElement === state.toast?.hostElement.nativeElement) {
                if (!state.toast?.dynamic) {
                    // @ts-ignore
                    state.toast.visible = false;
                }
            }
        });
    }
    stateToasterSubscribe(subscribe = true) {
        if (subscribe) {
            this.stateToasterSubscription = this.toasterService.toasterState$.subscribe((state) => {
                if (state.show === false) {
                    this.removeToast(state);
                }
                if (state.show === true && state.toast?.dynamic === undefined) {
                }
            });
        }
        else {
            this.stateToasterSubscription.unsubscribe();
        }
    }
}
ToasterComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ToasterComponent, deps: [{ token: i0.ComponentFactoryResolver }, { token: i0.ElementRef }, { token: i0.Renderer2 }, { token: i1.ToasterService }], target: i0.ɵɵFactoryTarget.Component });
ToasterComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: ToasterComponent, selector: "c-toaster", inputs: { placement: "placement", position: "position" }, host: { properties: { "class": "this.hostClasses" } }, queries: [{ propertyName: "contentToasts", predicate: ToastComponent, read: ViewContainerRef }], viewQueries: [{ propertyName: "toasterHost", first: true, predicate: ToasterHostDirective, descendants: true, static: true }], exportAs: ["cToaster"], ngImport: i0, template: "<ng-template cToasterHost></ng-template>\n<ng-content cToasterHost></ng-content>\n", dependencies: [{ kind: "directive", type: i2.ToasterHostDirective, selector: "[cToasterHost]", exportAs: ["cToasterHost"] }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: ToasterComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-toaster', exportAs: 'cToaster', template: "<ng-template cToasterHost></ng-template>\n<ng-content cToasterHost></ng-content>\n" }]
        }], ctorParameters: function () { return [{ type: i0.ComponentFactoryResolver }, { type: i0.ElementRef }, { type: i0.Renderer2 }, { type: i1.ToasterService }]; }, propDecorators: { placement: [{
                type: Input
            }], position: [{
                type: Input
            }], toasterHost: [{
                type: ViewChild,
                args: [ToasterHostDirective, { static: true }]
            }], contentToasts: [{
                type: ContentChildren,
                args: [ToastComponent, { read: ViewContainerRef }]
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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