import { Directive, HostBinding, Inject, Input } from '@angular/core';
import { DOCUMENT } from '@angular/common';
import { createPopper } from '@popperjs/core';
import { TooltipComponent } from './tooltip/tooltip.component';
import { ListenersService } from '../services/listeners.service';
import * as i0 from "@angular/core";
import * as i1 from "../services/listeners.service";
export class TooltipDirective {
    constructor(document, renderer, hostElement, componentFactoryResolver, viewContainerRef, listenersService) {
        this.document = document;
        this.renderer = renderer;
        this.hostElement = hostElement;
        this.componentFactoryResolver = componentFactoryResolver;
        this.viewContainerRef = viewContainerRef;
        this.listenersService = listenersService;
        /**
         * Content of tooltip
         * @type {string | TemplateRef}
         */
        this.content = '';
        /**
         * Describes the placement of your component after Popper.js has applied all the modifiers that may have flipped or altered the originally provided placement property.
         */
        this.placement = 'top';
        /**
         * Sets which event handlers you’d like provided to your toggle prop. You can specify one trigger or an array of them.
         * @type {'hover' | 'focus' | 'click'}
         */
        this.trigger = 'hover';
        this._visible = false;
        this._popperOptions = {
            modifiers: [
                {
                    name: 'offset',
                    options: {
                        offset: [0, 0],
                    },
                },
            ],
        };
    }
    /**
     * Optional popper Options object, takes precedence over cPopoverPlacement prop
     * @type Partial<Options>
     */
    set popperOptions(value) {
        this._popperOptions = { ...this._popperOptions, placement: this.placement, ...value };
    }
    ;
    get popperOptions() {
        return { placement: this.placement, ...this._popperOptions };
    }
    /**
     * Toggle the visibility of tooltip component.
     */
    set visible(value) {
        this._visible = value;
        value ? this.addTooltipElement() : this.removeTooltipElement();
        this.tooltipRef?.changeDetectorRef.markForCheck();
    }
    get visible() {
        return this._visible;
    }
    get ariaDescribedBy() {
        return this.tooltipId ? this.tooltipId : null;
    }
    ngOnChanges(changes) {
        if (changes['visible']) {
            changes['visible'].currentValue ? this.addTooltipElement() : this.removeTooltipElement();
        }
    }
    ngOnDestroy() {
        this.clearListeners();
        this.destroyTooltipElement();
    }
    ngOnInit() {
        // this.createTooltipElement();
        this.setListeners();
    }
    setListeners() {
        const config = {
            hostElement: this.hostElement,
            trigger: this.trigger,
            callbackToggle: () => {
                this.visible = !this.visible;
            },
            callbackOff: () => {
                this.visible = false;
            },
            callbackOn: () => {
                this.visible = true;
            }
        };
        this.listenersService.setListeners(config);
    }
    clearListeners() {
        this.listenersService.clearListeners();
    }
    getUID(prefix) {
        let uid = prefix ?? 'random-id';
        do {
            uid = `${prefix}-${Math.floor(Math.random() * 1000000).toString(10)}`;
        } while (this.document.getElementById(uid));
        return uid;
    }
    createTooltipElement() {
        if (!this.tooltipRef) {
            const tooltipComponent = this.componentFactoryResolver.resolveComponentFactory(TooltipComponent);
            this.tooltipRef = this.viewContainerRef.createComponent(tooltipComponent);
        }
    }
    destroyTooltipElement() {
        this.tooltip?.remove();
        this.tooltipRef?.destroy();
        // @ts-ignore
        this.tooltipRef = undefined;
        this.popperInstance?.destroy();
        this.viewContainerRef.detach();
        this.viewContainerRef.clear();
    }
    addTooltipElement() {
        if (!this.tooltipRef) {
            this.createTooltipElement();
        }
        this.tooltipRef.instance.content = this.content;
        this.tooltip = this.tooltipRef.location.nativeElement;
        setTimeout(() => {
            this.popperInstance = createPopper(this.hostElement.nativeElement, this.tooltip, { ...this.popperOptions });
            setTimeout(() => {
                this.tooltipId = this.getUID('tooltip');
                this.tooltipRef.instance.id = this.tooltipId;
                this.tooltipRef.instance.visible = this.visible;
                this.renderer.appendChild(this.document.body, this.tooltip);
                this.popperInstance.forceUpdate();
                this.tooltipRef.changeDetectorRef.markForCheck();
                // this.tooltipRef.changeDetectorRef.detectChanges();
            }, 100);
        });
    }
    removeTooltipElement() {
        if (!this.tooltipRef) {
            return;
        }
        this.tooltipRef.instance.visible = this.visible;
        setTimeout(() => {
            // this.tooltipRef.changeDetectorRef.detectChanges();
            this.tooltipRef.instance.id = undefined;
            this.renderer.removeChild(this.document.body, this.tooltip);
            this.popperInstance?.destroy();
            this.tooltipId = '';
        }, 300);
    }
}
TooltipDirective.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: TooltipDirective, deps: [{ token: DOCUMENT }, { token: i0.Renderer2 }, { token: i0.ElementRef }, { token: i0.ComponentFactoryResolver }, { token: i0.ViewContainerRef }, { token: i1.ListenersService }], target: i0.ɵɵFactoryTarget.Directive });
TooltipDirective.ɵdir = i0.ɵɵngDeclareDirective({ minVersion: "14.0.0", version: "14.0.5", type: TooltipDirective, selector: "[cTooltip]", inputs: { content: ["cTooltip", "content"], popperOptions: ["cTooltipOptions", "popperOptions"], placement: ["cTooltipPlacement", "placement"], trigger: ["cTooltipTrigger", "trigger"], visible: ["cTooltipVisible", "visible"] }, host: { properties: { "attr.aria-describedby": "this.ariaDescribedBy" } }, providers: [ListenersService], exportAs: ["cTooltip"], usesOnChanges: true, ngImport: i0 });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: TooltipDirective, decorators: [{
            type: Directive,
            args: [{
                    selector: '[cTooltip]',
                    exportAs: 'cTooltip',
                    providers: [ListenersService]
                }]
        }], ctorParameters: function () { return [{ type: undefined, decorators: [{
                    type: Inject,
                    args: [DOCUMENT]
                }] }, { type: i0.Renderer2 }, { type: i0.ElementRef }, { type: i0.ComponentFactoryResolver }, { type: i0.ViewContainerRef }, { type: i1.ListenersService }]; }, propDecorators: { content: [{
                type: Input,
                args: ['cTooltip']
            }], popperOptions: [{
                type: Input,
                args: ['cTooltipOptions']
            }], placement: [{
                type: Input,
                args: ['cTooltipPlacement']
            }], trigger: [{
                type: Input,
                args: ['cTooltipTrigger']
            }], visible: [{
                type: Input,
                args: ['cTooltipVisible']
            }], ariaDescribedBy: [{
                type: HostBinding,
                args: ['attr.aria-describedby']
            }] } });
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidG9vbHRpcC5kaXJlY3RpdmUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi8uLi8uLi9wcm9qZWN0cy9jb3JldWktYW5ndWxhci9zcmMvbGliL3Rvb2x0aXAvdG9vbHRpcC5kaXJlY3RpdmUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IkFBQUEsT0FBTyxFQUdMLFNBQVMsRUFFVCxXQUFXLEVBQ1gsTUFBTSxFQUNOLEtBQUssRUFPTixNQUFNLGVBQWUsQ0FBQztBQUN2QixPQUFPLEVBQUUsUUFBUSxFQUFFLE1BQU0saUJBQWlCLENBQUM7QUFDM0MsT0FBTyxFQUFFLFlBQVksRUFBcUIsTUFBTSxnQkFBZ0IsQ0FBQztBQUdqRSxPQUFPLEVBQUUsZ0JBQWdCLEVBQUUsTUFBTSw2QkFBNkIsQ0FBQztBQUMvRCxPQUFPLEVBQW9CLGdCQUFnQixFQUFFLE1BQU0sK0JBQStCLENBQUM7OztBQU9uRixNQUFNLE9BQU8sZ0JBQWdCO0lBZ0UzQixZQUM0QixRQUFhLEVBQy9CLFFBQW1CLEVBQ25CLFdBQXVCLEVBQ3ZCLHdCQUFrRCxFQUNsRCxnQkFBa0MsRUFDbEMsZ0JBQWtDO1FBTGhCLGFBQVEsR0FBUixRQUFRLENBQUs7UUFDL0IsYUFBUSxHQUFSLFFBQVEsQ0FBVztRQUNuQixnQkFBVyxHQUFYLFdBQVcsQ0FBWTtRQUN2Qiw2QkFBd0IsR0FBeEIsd0JBQXdCLENBQTBCO1FBQ2xELHFCQUFnQixHQUFoQixnQkFBZ0IsQ0FBa0I7UUFDbEMscUJBQWdCLEdBQWhCLGdCQUFnQixDQUFrQjtRQXBFNUM7OztXQUdHO1FBQ2dCLFlBQU8sR0FBOEIsRUFBRSxDQUFDO1FBYzNEOztXQUVHO1FBQ3lCLGNBQVMsR0FBd0MsS0FBSyxDQUFDO1FBQ25GOzs7V0FHRztRQUN1QixZQUFPLEdBQTBCLE9BQU8sQ0FBQztRQWMzRCxhQUFRLEdBQUcsS0FBSyxDQUFDO1FBV2pCLG1CQUFjLEdBQXFCO1lBQ3pDLFNBQVMsRUFBRTtnQkFDVDtvQkFDRSxJQUFJLEVBQUUsUUFBUTtvQkFDZCxPQUFPLEVBQUU7d0JBQ1AsTUFBTSxFQUFFLENBQUMsQ0FBQyxFQUFFLENBQUMsQ0FBQztxQkFDZjtpQkFDRjthQUNGO1NBQ0YsQ0FBQztJQVNDLENBQUM7SUEvREo7OztPQUdHO0lBQ0gsSUFDSSxhQUFhLENBQUMsS0FBdUI7UUFDdkMsSUFBSSxDQUFDLGNBQWMsR0FBRyxFQUFDLEdBQUcsSUFBSSxDQUFDLGNBQWMsRUFBRSxTQUFTLEVBQUUsSUFBSSxDQUFDLFNBQVMsRUFBRSxHQUFHLEtBQUssRUFBQyxDQUFDO0lBQ3RGLENBQUM7SUFBQSxDQUFDO0lBQ0YsSUFBSSxhQUFhO1FBQ2YsT0FBTyxFQUFDLFNBQVMsRUFBRSxJQUFJLENBQUMsU0FBUyxFQUFFLEdBQUcsSUFBSSxDQUFDLGNBQWMsRUFBQyxDQUFDO0lBQzdELENBQUM7SUFZRDs7T0FFRztJQUNILElBQ0ksT0FBTyxDQUFDLEtBQWM7UUFDeEIsSUFBSSxDQUFDLFFBQVEsR0FBRyxLQUFLLENBQUM7UUFDdEIsS0FBSyxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsaUJBQWlCLEVBQUUsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUM7UUFDL0QsSUFBSSxDQUFDLFVBQVUsRUFBRSxpQkFBaUIsQ0FBQyxZQUFZLEVBQUUsQ0FBQztJQUNwRCxDQUFDO0lBQ0QsSUFBSSxPQUFPO1FBQ1QsT0FBTyxJQUFJLENBQUMsUUFBUSxDQUFDO0lBQ3ZCLENBQUM7SUFHRCxJQUEwQyxlQUFlO1FBQ3ZELE9BQU8sSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUMsSUFBSSxDQUFDO0lBQ2hELENBQUM7SUEyQkQsV0FBVyxDQUFDLE9BQXNCO1FBQ2hDLElBQUksT0FBTyxDQUFDLFNBQVMsQ0FBQyxFQUFFO1lBQ3RCLE9BQU8sQ0FBQyxTQUFTLENBQUMsQ0FBQyxZQUFZLENBQUMsQ0FBQyxDQUFDLElBQUksQ0FBQyxpQkFBaUIsRUFBRSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsb0JBQW9CLEVBQUUsQ0FBQztTQUMxRjtJQUNILENBQUM7SUFFRCxXQUFXO1FBQ1QsSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1FBQ3RCLElBQUksQ0FBQyxxQkFBcUIsRUFBRSxDQUFDO0lBQy9CLENBQUM7SUFFRCxRQUFRO1FBQ04sK0JBQStCO1FBQy9CLElBQUksQ0FBQyxZQUFZLEVBQUUsQ0FBQztJQUN0QixDQUFDO0lBRU8sWUFBWTtRQUNsQixNQUFNLE1BQU0sR0FBcUI7WUFDL0IsV0FBVyxFQUFFLElBQUksQ0FBQyxXQUFXO1lBQzdCLE9BQU8sRUFBRSxJQUFJLENBQUMsT0FBTztZQUNyQixjQUFjLEVBQUUsR0FBRyxFQUFFO2dCQUNuQixJQUFJLENBQUMsT0FBTyxHQUFHLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQztZQUMvQixDQUFDO1lBQ0QsV0FBVyxFQUFFLEdBQUcsRUFBRTtnQkFDaEIsSUFBSSxDQUFDLE9BQU8sR0FBRyxLQUFLLENBQUM7WUFDdkIsQ0FBQztZQUNELFVBQVUsRUFBRSxHQUFHLEVBQUU7Z0JBQ2YsSUFBSSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUM7WUFDdEIsQ0FBQztTQUNGLENBQUE7UUFDRCxJQUFJLENBQUMsZ0JBQWdCLENBQUMsWUFBWSxDQUFDLE1BQU0sQ0FBQyxDQUFBO0lBQzVDLENBQUM7SUFFTyxjQUFjO1FBQ3BCLElBQUksQ0FBQyxnQkFBZ0IsQ0FBQyxjQUFjLEVBQUUsQ0FBQztJQUN6QyxDQUFDO0lBRU8sTUFBTSxDQUFDLE1BQWM7UUFDM0IsSUFBSSxHQUFHLEdBQUcsTUFBTSxJQUFJLFdBQVcsQ0FBQztRQUNoQyxHQUFHO1lBQ0QsR0FBRyxHQUFHLEdBQUcsTUFBTSxJQUFJLElBQUksQ0FBQyxLQUFLLENBQUMsSUFBSSxDQUFDLE1BQU0sRUFBRSxHQUFHLE9BQU8sQ0FBQyxDQUFDLFFBQVEsQ0FBQyxFQUFFLENBQUMsRUFBRSxDQUFDO1NBQ3ZFLFFBQVEsSUFBSSxDQUFDLFFBQVEsQ0FBQyxjQUFjLENBQUMsR0FBRyxDQUFDLEVBQUU7UUFFNUMsT0FBTyxHQUFHLENBQUM7SUFDYixDQUFDO0lBRU8sb0JBQW9CO1FBQzFCLElBQUksQ0FBQyxJQUFJLENBQUMsVUFBVSxFQUFFO1lBQ3BCLE1BQU0sZ0JBQWdCLEdBQUcsSUFBSSxDQUFDLHdCQUF3QixDQUFDLHVCQUF1QixDQUFDLGdCQUFnQixDQUFDLENBQUM7WUFDakcsSUFBSSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsZ0JBQWdCLENBQUMsZUFBZSxDQUFDLGdCQUFnQixDQUFDLENBQUM7U0FDM0U7SUFDSCxDQUFDO0lBRU8scUJBQXFCO1FBQzNCLElBQUksQ0FBQyxPQUFPLEVBQUUsTUFBTSxFQUFFLENBQUM7UUFDdkIsSUFBSSxDQUFDLFVBQVUsRUFBRSxPQUFPLEVBQUUsQ0FBQztRQUMzQixhQUFhO1FBQ2IsSUFBSSxDQUFDLFVBQVUsR0FBRyxTQUFTLENBQUM7UUFDNUIsSUFBSSxDQUFDLGNBQWMsRUFBRSxPQUFPLEVBQUUsQ0FBQztRQUMvQixJQUFJLENBQUMsZ0JBQWdCLENBQUMsTUFBTSxFQUFFLENBQUM7UUFDL0IsSUFBSSxDQUFDLGdCQUFnQixDQUFDLEtBQUssRUFBRSxDQUFDO0lBQ2hDLENBQUM7SUFFTyxpQkFBaUI7UUFDdkIsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDcEIsSUFBSSxDQUFDLG9CQUFvQixFQUFFLENBQUM7U0FDN0I7UUFDRCxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztRQUNoRCxJQUFJLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLGFBQWEsQ0FBQztRQUV0RCxVQUFVLENBQUMsR0FBRyxFQUFFO1lBQ2QsSUFBSSxDQUFDLGNBQWMsR0FBRyxZQUFZLENBQ2hDLElBQUksQ0FBQyxXQUFXLENBQUMsYUFBYSxFQUM5QixJQUFJLENBQUMsT0FBTyxFQUNaLEVBQUUsR0FBRyxJQUFJLENBQUMsYUFBYSxFQUFFLENBQzFCLENBQUM7WUFDRixVQUFVLENBQUMsR0FBRyxFQUFFO2dCQUNkLElBQUksQ0FBQyxTQUFTLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsQ0FBQztnQkFDeEMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsRUFBRSxHQUFHLElBQUksQ0FBQyxTQUFTLENBQUM7Z0JBQzdDLElBQUksQ0FBQyxVQUFVLENBQUMsUUFBUSxDQUFDLE9BQU8sR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDO2dCQUNoRCxJQUFJLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxJQUFJLENBQUMsUUFBUSxDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7Z0JBQzVELElBQUksQ0FBQyxjQUFjLENBQUMsV0FBVyxFQUFFLENBQUM7Z0JBQ2xDLElBQUksQ0FBQyxVQUFVLENBQUMsaUJBQWlCLENBQUMsWUFBWSxFQUFFLENBQUM7Z0JBQ2pELHFEQUFxRDtZQUN2RCxDQUFDLEVBQUUsR0FBRyxDQUFDLENBQUM7UUFDVixDQUFDLENBQUMsQ0FBQTtJQUNKLENBQUM7SUFFTyxvQkFBb0I7UUFDMUIsSUFBSSxDQUFDLElBQUksQ0FBQyxVQUFVLEVBQUU7WUFDcEIsT0FBTTtTQUNQO1FBQ0QsSUFBSSxDQUFDLFVBQVUsQ0FBQyxRQUFRLENBQUMsT0FBTyxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUM7UUFDaEQsVUFBVSxDQUFDLEdBQUcsRUFBRTtZQUNkLHFEQUFxRDtZQUNyRCxJQUFJLENBQUMsVUFBVSxDQUFDLFFBQVEsQ0FBQyxFQUFFLEdBQUcsU0FBUyxDQUFDO1lBQ3hDLElBQUksQ0FBQyxRQUFRLENBQUMsV0FBVyxDQUFDLElBQUksQ0FBQyxRQUFRLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztZQUM1RCxJQUFJLENBQUMsY0FBYyxFQUFFLE9BQU8sRUFBRSxDQUFDO1lBQy9CLElBQUksQ0FBQyxTQUFTLEdBQUcsRUFBRSxDQUFDO1FBQ3RCLENBQUMsRUFBRSxHQUFHLENBQUMsQ0FBQztJQUNWLENBQUM7OzZHQTdLVSxnQkFBZ0Isa0JBaUVqQixRQUFRO2lHQWpFUCxnQkFBZ0Isb1ZBRmhCLENBQUMsZ0JBQWdCLENBQUM7MkZBRWxCLGdCQUFnQjtrQkFMNUIsU0FBUzttQkFBQztvQkFDVCxRQUFRLEVBQUUsWUFBWTtvQkFDdEIsUUFBUSxFQUFFLFVBQVU7b0JBQ3BCLFNBQVMsRUFBRSxDQUFDLGdCQUFnQixDQUFDO2lCQUM5Qjs7MEJBa0VJLE1BQU07MkJBQUMsUUFBUTtrTUEzREMsT0FBTztzQkFBekIsS0FBSzt1QkFBQyxVQUFVO2dCQU9iLGFBQWE7c0JBRGhCLEtBQUs7dUJBQUMsaUJBQWlCO2dCQVdJLFNBQVM7c0JBQXBDLEtBQUs7dUJBQUMsbUJBQW1CO2dCQUtBLE9BQU87c0JBQWhDLEtBQUs7dUJBQUMsaUJBQWlCO2dCQU1wQixPQUFPO3NCQURWLEtBQUs7dUJBQUMsaUJBQWlCO2dCQVdrQixlQUFlO3NCQUF4RCxXQUFXO3VCQUFDLHVCQUF1QiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7XHJcbiAgQ29tcG9uZW50RmFjdG9yeVJlc29sdmVyLFxyXG4gIENvbXBvbmVudFJlZixcclxuICBEaXJlY3RpdmUsXHJcbiAgRWxlbWVudFJlZixcclxuICBIb3N0QmluZGluZyxcclxuICBJbmplY3QsXHJcbiAgSW5wdXQsIE9uQ2hhbmdlcyxcclxuICBPbkRlc3Ryb3ksXHJcbiAgT25Jbml0LFxyXG4gIFJlbmRlcmVyMixcclxuICBTaW1wbGVDaGFuZ2VzLFxyXG4gIFRlbXBsYXRlUmVmLFxyXG4gIFZpZXdDb250YWluZXJSZWZcclxufSBmcm9tICdAYW5ndWxhci9jb3JlJztcclxuaW1wb3J0IHsgRE9DVU1FTlQgfSBmcm9tICdAYW5ndWxhci9jb21tb24nO1xyXG5pbXBvcnQgeyBjcmVhdGVQb3BwZXIsIEluc3RhbmNlLCBPcHRpb25zIH0gZnJvbSAnQHBvcHBlcmpzL2NvcmUnO1xyXG5cclxuaW1wb3J0IHsgVHJpZ2dlcnMgfSBmcm9tICcuLi9jb3JldWkudHlwZXMnO1xyXG5pbXBvcnQgeyBUb29sdGlwQ29tcG9uZW50IH0gZnJvbSAnLi90b29sdGlwL3Rvb2x0aXAuY29tcG9uZW50JztcclxuaW1wb3J0IHsgSUxpc3RlbmVyc0NvbmZpZywgTGlzdGVuZXJzU2VydmljZSB9IGZyb20gJy4uL3NlcnZpY2VzL2xpc3RlbmVycy5zZXJ2aWNlJztcclxuXHJcbkBEaXJlY3RpdmUoe1xyXG4gIHNlbGVjdG9yOiAnW2NUb29sdGlwXScsXHJcbiAgZXhwb3J0QXM6ICdjVG9vbHRpcCcsXHJcbiAgcHJvdmlkZXJzOiBbTGlzdGVuZXJzU2VydmljZV1cclxufSlcclxuZXhwb3J0IGNsYXNzIFRvb2x0aXBEaXJlY3RpdmUgaW1wbGVtZW50cyBPbkNoYW5nZXMsIE9uRGVzdHJveSwgT25Jbml0IHtcclxuXHJcbiAgLyoqXHJcbiAgICogQ29udGVudCBvZiB0b29sdGlwXHJcbiAgICogQHR5cGUge3N0cmluZyB8IFRlbXBsYXRlUmVmfVxyXG4gICAqL1xyXG4gIEBJbnB1dCgnY1Rvb2x0aXAnKSBjb250ZW50OiBzdHJpbmcgfCBUZW1wbGF0ZVJlZjxhbnk+ID0gJyc7XHJcblxyXG4gIC8qKlxyXG4gICAqIE9wdGlvbmFsIHBvcHBlciBPcHRpb25zIG9iamVjdCwgdGFrZXMgcHJlY2VkZW5jZSBvdmVyIGNQb3BvdmVyUGxhY2VtZW50IHByb3BcclxuICAgKiBAdHlwZSBQYXJ0aWFsPE9wdGlvbnM+XHJcbiAgICovXHJcbiAgQElucHV0KCdjVG9vbHRpcE9wdGlvbnMnKVxyXG4gIHNldCBwb3BwZXJPcHRpb25zKHZhbHVlOiBQYXJ0aWFsPE9wdGlvbnM+KSB7XHJcbiAgICB0aGlzLl9wb3BwZXJPcHRpb25zID0gey4uLnRoaXMuX3BvcHBlck9wdGlvbnMsIHBsYWNlbWVudDogdGhpcy5wbGFjZW1lbnQsIC4uLnZhbHVlfTtcclxuICB9O1xyXG4gIGdldCBwb3BwZXJPcHRpb25zKCk6IFBhcnRpYWw8T3B0aW9ucz4ge1xyXG4gICAgcmV0dXJuIHtwbGFjZW1lbnQ6IHRoaXMucGxhY2VtZW50LCAuLi50aGlzLl9wb3BwZXJPcHRpb25zfTtcclxuICB9XHJcblxyXG4gIC8qKlxyXG4gICAqIERlc2NyaWJlcyB0aGUgcGxhY2VtZW50IG9mIHlvdXIgY29tcG9uZW50IGFmdGVyIFBvcHBlci5qcyBoYXMgYXBwbGllZCBhbGwgdGhlIG1vZGlmaWVycyB0aGF0IG1heSBoYXZlIGZsaXBwZWQgb3IgYWx0ZXJlZCB0aGUgb3JpZ2luYWxseSBwcm92aWRlZCBwbGFjZW1lbnQgcHJvcGVydHkuXHJcbiAgICovXHJcbiAgQElucHV0KCdjVG9vbHRpcFBsYWNlbWVudCcpIHBsYWNlbWVudDogJ3RvcCcgfCAnYm90dG9tJyB8ICdsZWZ0JyB8ICdyaWdodCcgPSAndG9wJztcclxuICAvKipcclxuICAgKiBTZXRzIHdoaWNoIGV2ZW50IGhhbmRsZXJzIHlvdeKAmWQgbGlrZSBwcm92aWRlZCB0byB5b3VyIHRvZ2dsZSBwcm9wLiBZb3UgY2FuIHNwZWNpZnkgb25lIHRyaWdnZXIgb3IgYW4gYXJyYXkgb2YgdGhlbS5cclxuICAgKiBAdHlwZSB7J2hvdmVyJyB8ICdmb2N1cycgfCAnY2xpY2snfVxyXG4gICAqL1xyXG4gIEBJbnB1dCgnY1Rvb2x0aXBUcmlnZ2VyJykgdHJpZ2dlcjogVHJpZ2dlcnMgfCBUcmlnZ2Vyc1tdID0gJ2hvdmVyJztcclxuXHJcbiAgLyoqXHJcbiAgICogVG9nZ2xlIHRoZSB2aXNpYmlsaXR5IG9mIHRvb2x0aXAgY29tcG9uZW50LlxyXG4gICAqL1xyXG4gIEBJbnB1dCgnY1Rvb2x0aXBWaXNpYmxlJylcclxuICBzZXQgdmlzaWJsZSh2YWx1ZTogYm9vbGVhbikge1xyXG4gICAgdGhpcy5fdmlzaWJsZSA9IHZhbHVlO1xyXG4gICAgdmFsdWUgPyB0aGlzLmFkZFRvb2x0aXBFbGVtZW50KCkgOiB0aGlzLnJlbW92ZVRvb2x0aXBFbGVtZW50KCk7XHJcbiAgICB0aGlzLnRvb2x0aXBSZWY/LmNoYW5nZURldGVjdG9yUmVmLm1hcmtGb3JDaGVjaygpO1xyXG4gIH1cclxuICBnZXQgdmlzaWJsZSgpIHtcclxuICAgIHJldHVybiB0aGlzLl92aXNpYmxlO1xyXG4gIH1cclxuICBwcml2YXRlIF92aXNpYmxlID0gZmFsc2U7XHJcblxyXG4gIEBIb3N0QmluZGluZygnYXR0ci5hcmlhLWRlc2NyaWJlZGJ5JykgZ2V0IGFyaWFEZXNjcmliZWRCeSgpOiBzdHJpbmcgfCBudWxsIHtcclxuICAgIHJldHVybiB0aGlzLnRvb2x0aXBJZCA/IHRoaXMudG9vbHRpcElkIDogbnVsbDtcclxuICB9XHJcblxyXG4gIHByaXZhdGUgdG9vbHRpcCE6IEhUTUxEaXZFbGVtZW50O1xyXG4gIHByaXZhdGUgdG9vbHRpcElkITogc3RyaW5nO1xyXG4gIHByaXZhdGUgdG9vbHRpcFJlZiE6IENvbXBvbmVudFJlZjxUb29sdGlwQ29tcG9uZW50PjtcclxuICBwcml2YXRlIHBvcHBlckluc3RhbmNlITogSW5zdGFuY2U7XHJcblxyXG4gIHByaXZhdGUgX3BvcHBlck9wdGlvbnM6IFBhcnRpYWw8T3B0aW9ucz4gPSB7XHJcbiAgICBtb2RpZmllcnM6IFtcclxuICAgICAge1xyXG4gICAgICAgIG5hbWU6ICdvZmZzZXQnLFxyXG4gICAgICAgIG9wdGlvbnM6IHtcclxuICAgICAgICAgIG9mZnNldDogWzAsIDBdLFxyXG4gICAgICAgIH0sXHJcbiAgICAgIH0sXHJcbiAgICBdLFxyXG4gIH07XHJcblxyXG4gIGNvbnN0cnVjdG9yKFxyXG4gICAgQEluamVjdChET0NVTUVOVCkgcHJpdmF0ZSBkb2N1bWVudDogYW55LFxyXG4gICAgcHJpdmF0ZSByZW5kZXJlcjogUmVuZGVyZXIyLFxyXG4gICAgcHJpdmF0ZSBob3N0RWxlbWVudDogRWxlbWVudFJlZixcclxuICAgIHByaXZhdGUgY29tcG9uZW50RmFjdG9yeVJlc29sdmVyOiBDb21wb25lbnRGYWN0b3J5UmVzb2x2ZXIsXHJcbiAgICBwcml2YXRlIHZpZXdDb250YWluZXJSZWY6IFZpZXdDb250YWluZXJSZWYsXHJcbiAgICBwcml2YXRlIGxpc3RlbmVyc1NlcnZpY2U6IExpc3RlbmVyc1NlcnZpY2VcclxuICApIHt9XHJcblxyXG4gIG5nT25DaGFuZ2VzKGNoYW5nZXM6IFNpbXBsZUNoYW5nZXMpOiB2b2lkIHtcclxuICAgIGlmIChjaGFuZ2VzWyd2aXNpYmxlJ10pIHtcclxuICAgICAgY2hhbmdlc1sndmlzaWJsZSddLmN1cnJlbnRWYWx1ZSA/IHRoaXMuYWRkVG9vbHRpcEVsZW1lbnQoKSA6IHRoaXMucmVtb3ZlVG9vbHRpcEVsZW1lbnQoKTtcclxuICAgIH1cclxuICB9XHJcblxyXG4gIG5nT25EZXN0cm95KCk6IHZvaWQge1xyXG4gICAgdGhpcy5jbGVhckxpc3RlbmVycygpO1xyXG4gICAgdGhpcy5kZXN0cm95VG9vbHRpcEVsZW1lbnQoKTtcclxuICB9XHJcblxyXG4gIG5nT25Jbml0KCk6IHZvaWQge1xyXG4gICAgLy8gdGhpcy5jcmVhdGVUb29sdGlwRWxlbWVudCgpO1xyXG4gICAgdGhpcy5zZXRMaXN0ZW5lcnMoKTtcclxuICB9XHJcblxyXG4gIHByaXZhdGUgc2V0TGlzdGVuZXJzKCk6IHZvaWQge1xyXG4gICAgY29uc3QgY29uZmlnOiBJTGlzdGVuZXJzQ29uZmlnID0ge1xyXG4gICAgICBob3N0RWxlbWVudDogdGhpcy5ob3N0RWxlbWVudCxcclxuICAgICAgdHJpZ2dlcjogdGhpcy50cmlnZ2VyLFxyXG4gICAgICBjYWxsYmFja1RvZ2dsZTogKCkgPT4ge1xyXG4gICAgICAgIHRoaXMudmlzaWJsZSA9ICF0aGlzLnZpc2libGU7XHJcbiAgICAgIH0sXHJcbiAgICAgIGNhbGxiYWNrT2ZmOiAoKSA9PiB7XHJcbiAgICAgICAgdGhpcy52aXNpYmxlID0gZmFsc2U7XHJcbiAgICAgIH0sXHJcbiAgICAgIGNhbGxiYWNrT246ICgpID0+IHtcclxuICAgICAgICB0aGlzLnZpc2libGUgPSB0cnVlO1xyXG4gICAgICB9XHJcbiAgICB9XHJcbiAgICB0aGlzLmxpc3RlbmVyc1NlcnZpY2Uuc2V0TGlzdGVuZXJzKGNvbmZpZylcclxuICB9XHJcblxyXG4gIHByaXZhdGUgY2xlYXJMaXN0ZW5lcnMoKTogdm9pZCB7XHJcbiAgICB0aGlzLmxpc3RlbmVyc1NlcnZpY2UuY2xlYXJMaXN0ZW5lcnMoKTtcclxuICB9XHJcblxyXG4gIHByaXZhdGUgZ2V0VUlEKHByZWZpeDogc3RyaW5nKTogc3RyaW5nIHtcclxuICAgIGxldCB1aWQgPSBwcmVmaXggPz8gJ3JhbmRvbS1pZCc7XHJcbiAgICBkbyB7XHJcbiAgICAgIHVpZCA9IGAke3ByZWZpeH0tJHtNYXRoLmZsb29yKE1hdGgucmFuZG9tKCkgKiAxMDAwMDAwKS50b1N0cmluZygxMCl9YDtcclxuICAgIH0gd2hpbGUgKHRoaXMuZG9jdW1lbnQuZ2V0RWxlbWVudEJ5SWQodWlkKSk7XHJcblxyXG4gICAgcmV0dXJuIHVpZDtcclxuICB9XHJcblxyXG4gIHByaXZhdGUgY3JlYXRlVG9vbHRpcEVsZW1lbnQoKTogdm9pZCB7XHJcbiAgICBpZiAoIXRoaXMudG9vbHRpcFJlZikge1xyXG4gICAgICBjb25zdCB0b29sdGlwQ29tcG9uZW50ID0gdGhpcy5jb21wb25lbnRGYWN0b3J5UmVzb2x2ZXIucmVzb2x2ZUNvbXBvbmVudEZhY3RvcnkoVG9vbHRpcENvbXBvbmVudCk7XHJcbiAgICAgIHRoaXMudG9vbHRpcFJlZiA9IHRoaXMudmlld0NvbnRhaW5lclJlZi5jcmVhdGVDb21wb25lbnQodG9vbHRpcENvbXBvbmVudCk7XHJcbiAgICB9XHJcbiAgfVxyXG5cclxuICBwcml2YXRlIGRlc3Ryb3lUb29sdGlwRWxlbWVudCgpOiB2b2lkIHtcclxuICAgIHRoaXMudG9vbHRpcD8ucmVtb3ZlKCk7XHJcbiAgICB0aGlzLnRvb2x0aXBSZWY/LmRlc3Ryb3koKTtcclxuICAgIC8vIEB0cy1pZ25vcmVcclxuICAgIHRoaXMudG9vbHRpcFJlZiA9IHVuZGVmaW5lZDtcclxuICAgIHRoaXMucG9wcGVySW5zdGFuY2U/LmRlc3Ryb3koKTtcclxuICAgIHRoaXMudmlld0NvbnRhaW5lclJlZi5kZXRhY2goKTtcclxuICAgIHRoaXMudmlld0NvbnRhaW5lclJlZi5jbGVhcigpO1xyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSBhZGRUb29sdGlwRWxlbWVudCgpOiB2b2lkIHtcclxuICAgIGlmICghdGhpcy50b29sdGlwUmVmKSB7XHJcbiAgICAgIHRoaXMuY3JlYXRlVG9vbHRpcEVsZW1lbnQoKTtcclxuICAgIH1cclxuICAgIHRoaXMudG9vbHRpcFJlZi5pbnN0YW5jZS5jb250ZW50ID0gdGhpcy5jb250ZW50O1xyXG4gICAgdGhpcy50b29sdGlwID0gdGhpcy50b29sdGlwUmVmLmxvY2F0aW9uLm5hdGl2ZUVsZW1lbnQ7XHJcblxyXG4gICAgc2V0VGltZW91dCgoKSA9PiB7XHJcbiAgICAgIHRoaXMucG9wcGVySW5zdGFuY2UgPSBjcmVhdGVQb3BwZXIoXHJcbiAgICAgICAgdGhpcy5ob3N0RWxlbWVudC5uYXRpdmVFbGVtZW50LFxyXG4gICAgICAgIHRoaXMudG9vbHRpcCxcclxuICAgICAgICB7IC4uLnRoaXMucG9wcGVyT3B0aW9ucyB9XHJcbiAgICAgICk7XHJcbiAgICAgIHNldFRpbWVvdXQoKCkgPT4ge1xyXG4gICAgICAgIHRoaXMudG9vbHRpcElkID0gdGhpcy5nZXRVSUQoJ3Rvb2x0aXAnKTtcclxuICAgICAgICB0aGlzLnRvb2x0aXBSZWYuaW5zdGFuY2UuaWQgPSB0aGlzLnRvb2x0aXBJZDtcclxuICAgICAgICB0aGlzLnRvb2x0aXBSZWYuaW5zdGFuY2UudmlzaWJsZSA9IHRoaXMudmlzaWJsZTtcclxuICAgICAgICB0aGlzLnJlbmRlcmVyLmFwcGVuZENoaWxkKHRoaXMuZG9jdW1lbnQuYm9keSwgdGhpcy50b29sdGlwKTtcclxuICAgICAgICB0aGlzLnBvcHBlckluc3RhbmNlLmZvcmNlVXBkYXRlKCk7XHJcbiAgICAgICAgdGhpcy50b29sdGlwUmVmLmNoYW5nZURldGVjdG9yUmVmLm1hcmtGb3JDaGVjaygpO1xyXG4gICAgICAgIC8vIHRoaXMudG9vbHRpcFJlZi5jaGFuZ2VEZXRlY3RvclJlZi5kZXRlY3RDaGFuZ2VzKCk7XHJcbiAgICAgIH0sIDEwMCk7XHJcbiAgICB9KVxyXG4gIH1cclxuXHJcbiAgcHJpdmF0ZSByZW1vdmVUb29sdGlwRWxlbWVudCgpOiB2b2lkIHtcclxuICAgIGlmICghdGhpcy50b29sdGlwUmVmKSB7XHJcbiAgICAgIHJldHVyblxyXG4gICAgfVxyXG4gICAgdGhpcy50b29sdGlwUmVmLmluc3RhbmNlLnZpc2libGUgPSB0aGlzLnZpc2libGU7XHJcbiAgICBzZXRUaW1lb3V0KCgpID0+IHtcclxuICAgICAgLy8gdGhpcy50b29sdGlwUmVmLmNoYW5nZURldGVjdG9yUmVmLmRldGVjdENoYW5nZXMoKTtcclxuICAgICAgdGhpcy50b29sdGlwUmVmLmluc3RhbmNlLmlkID0gdW5kZWZpbmVkO1xyXG4gICAgICB0aGlzLnJlbmRlcmVyLnJlbW92ZUNoaWxkKHRoaXMuZG9jdW1lbnQuYm9keSwgdGhpcy50b29sdGlwKTtcclxuICAgICAgdGhpcy5wb3BwZXJJbnN0YW5jZT8uZGVzdHJveSgpO1xyXG4gICAgICB0aGlzLnRvb2x0aXBJZCA9ICcnO1xyXG4gICAgfSwgMzAwKTtcclxuICB9XHJcbn1cclxuIl19