import { Component, HostBinding, Input } from '@angular/core';
import { coerceBooleanProperty } from '@angular/cdk/coercion';
import { CardComponent } from '../../card';
import * as i0 from "@angular/core";
import * as i1 from "@angular/common";
import * as i2 from "../../card/card-body.component";
export class WidgetStatBComponent extends CardComponent {
    constructor() {
        super();
        this._inverse = false;
    }
    /**
     * Invert colors from their default dark shade.
     * @type boolean
     */
    get inverse() {
        return this._inverse;
    }
    set inverse(value) {
        this._inverse = coerceBooleanProperty(value);
    }
    get hostClasses() {
        return {
            'card': true,
            [`bg-${this.color}`]: !!this.color,
            [`text-${this.textColor}`]: !!this.textColor,
            'text-high-emphasis-inverse': !!this.color
        };
    }
}
WidgetStatBComponent.ɵfac = i0.ɵɵngDeclareFactory({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: WidgetStatBComponent, deps: [], target: i0.ɵɵFactoryTarget.Component });
WidgetStatBComponent.ɵcmp = i0.ɵɵngDeclareComponent({ minVersion: "14.0.0", version: "14.0.5", type: WidgetStatBComponent, selector: "c-widget-stat-b", inputs: { color: "color", textColor: "textColor", title: "title", text: "text", value: "value", inverse: "inverse" }, host: { properties: { "class": "this.hostClasses" } }, exportAs: ["cWidgetStatB"], usesInheritance: true, ngImport: i0, template: "<c-card-body>\n  <div *ngIf=\"!!value\" class=\"fs-4 fw-semibold\">{{value}}</div>\n  <div *ngIf=\"!!title\">{{title}}</div>\n  <ng-content></ng-content>\n  <small *ngIf=\"text\" [ngClass]=\"inverse ? 'text-medium-emphasis-inverse' : 'text-medium-emphasis'\">\n    {{text}}\n  </small>\n</c-card-body>\n", styles: [""], dependencies: [{ kind: "directive", type: i1.NgClass, selector: "[ngClass]", inputs: ["class", "ngClass"] }, { kind: "directive", type: i1.NgIf, selector: "[ngIf]", inputs: ["ngIf", "ngIfThen", "ngIfElse"] }, { kind: "component", type: i2.CardBodyComponent, selector: "c-card-body, [c-card-body]" }] });
i0.ɵɵngDeclareClassMetadata({ minVersion: "12.0.0", version: "14.0.5", ngImport: i0, type: WidgetStatBComponent, decorators: [{
            type: Component,
            args: [{ selector: 'c-widget-stat-b', exportAs: 'cWidgetStatB', template: "<c-card-body>\n  <div *ngIf=\"!!value\" class=\"fs-4 fw-semibold\">{{value}}</div>\n  <div *ngIf=\"!!title\">{{title}}</div>\n  <ng-content></ng-content>\n  <small *ngIf=\"text\" [ngClass]=\"inverse ? 'text-medium-emphasis-inverse' : 'text-medium-emphasis'\">\n    {{text}}\n  </small>\n</c-card-body>\n" }]
        }], ctorParameters: function () { return []; }, propDecorators: { color: [{
                type: Input
            }], textColor: [{
                type: Input
            }], title: [{
                type: Input
            }], text: [{
                type: Input
            }], value: [{
                type: Input
            }], inverse: [{
                type: Input
            }], hostClasses: [{
                type: HostBinding,
                args: ['class']
            }] } });
//# sourceMappingURL=data:application/json;base64,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