import { InjectionToken } from '@angular/core';
export const PERFECT_SCROLLBAR_CONFIG = new InjectionToken('PERFECT_SCROLLBAR_CONFIG');
export class Geometry {
    constructor(x, y, w, h) {
        this.x = x;
        this.y = y;
        this.w = w;
        this.h = h;
    }
}
export class Position {
    constructor(x, y) {
        this.x = x;
        this.y = y;
    }
}
export const PerfectScrollbarEvents = [
    'psScrollY',
    'psScrollX',
    'psScrollUp',
    'psScrollDown',
    'psScrollLeft',
    'psScrollRight',
    'psYReachEnd',
    'psYReachStart',
    'psXReachEnd',
    'psXReachStart'
];
export class PerfectScrollbarConfig {
    constructor(config = {}) {
        this.assign(config);
    }
    assign(config = {}) {
        for (const key in config) {
            this[key] = config[key];
        }
    }
}
//# sourceMappingURL=data:application/json;base64,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