
# Create Customer Card Request

Defines the fields that are included in the request body of a request
to the `CreateCustomerCard` endpoint.

## Structure

`CreateCustomerCardRequest`

## Fields

| Name | Type | Tags | Description | Getter | Setter |
|  --- | --- | --- | --- | --- | --- |
| `cardNonce` | `string` | Required | A card nonce representing the credit card to link to the customer.<br><br>Card nonces are generated by the Square payment form when customers enter<br>their card information. For more information, see<br>[Walkthrough: Integrate Square Payments in a Website](https://developer.squareup.com/docs/web-payments/take-card-payment).<br><br>__NOTE:__ Card nonces generated by digital wallets (such as Apple Pay)<br>cannot be used to create a customer card. | getCardNonce(): string | setCardNonce(string cardNonce): void |
| `billingAddress` | [`?Address`](/doc/models/address.md) | Optional | Represents a postal address in a country. The address format is based<br>on an [open-source library from Google](https://github.com/google/libaddressinput). For more information,<br>see [AddressValidationMetadata](https://github.com/google/libaddressinput/wiki/AddressValidationMetadata).<br>This format has dedicated fields for four address components: postal code,<br>locality (city), administrative district (state, prefecture, or province), and<br>sublocality (town or village). These components have dedicated fields in the<br>`Address` object because software sometimes behaves differently based on them.<br>For example, sales tax software may charge different amounts of sales tax<br>based on the postal code, and some software is only available in<br>certain states due to compliance reasons.<br><br>For the remaining address components, the `Address` type provides the<br>`address_line_1` and `address_line_2` fields for free-form data entry.<br>These fields are free-form because the remaining address components have<br>too many variations around the world and typical software does not parse<br>these components. These fields enable users to enter anything they want.<br><br>Note that, in the current implementation, all other `Address` type fields are blank.<br>These include `address_line_3`, `sublocality_2`, `sublocality_3`,<br>`administrative_district_level_2`, `administrative_district_level_3`,<br>`first_name`, `last_name`, and `organization`.<br><br>When it comes to localization, the seller's language preferences<br>(see [Language preferences](https://developer.squareup.com/docs/locations-api#location-specific-and-seller-level-language-preferences))<br>are ignored for addresses. Even though Square products (such as Square Point of Sale<br>and the Seller Dashboard) mostly use a seller's language preference in<br>communication, when it comes to addresses, they will use English for a US address,<br>Japanese for an address in Japan, and so on. | getBillingAddress(): ?Address | setBillingAddress(?Address billingAddress): void |
| `cardholderName` | `?string` | Optional | The full name printed on the credit card. | getCardholderName(): ?string | setCardholderName(?string cardholderName): void |
| `verificationToken` | `?string` | Optional | An identifying token generated by [Payments.verifyBuyer()](https://developer.squareup.com/reference/sdks/web/payments/objects/Payments#Payments.verifyBuyer).<br>Verification tokens encapsulate customer device information and 3-D Secure<br>challenge results to indicate that Square has verified the buyer identity. | getVerificationToken(): ?string | setVerificationToken(?string verificationToken): void |

## Example (as JSON)

```json
{
  "billing_address": {
    "address_line_1": "500 Electric Ave",
    "address_line_2": "Suite 600",
    "administrative_district_level_1": "NY",
    "country": "US",
    "locality": "New York",
    "postal_code": "10003"
  },
  "card_nonce": "YOUR_CARD_NONCE",
  "cardholder_name": "Amelia Earhart"
}
```

